/*
 * Decompiled with CFR 0.152.
 */
package XMLConsumer;

import XMLConsumer.FtsTData;
import XMLConsumer.IEntry;
import XMLConsumer.Topic;
import hhapplet.BsscFontFixPatch;
import hhapplet.IActionSink;
import hhapplet.URLFileHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class FtsEntry
extends Topic
implements IEntry,
Cloneable {
    private static Color GREEN = new Color(0, 127, 0);
    private static final int FTS_INDENT = 2;
    private FtsTData m_FtsData;
    private boolean m_bSelect;
    private boolean m_bHighLight;
    private static int m_indent = 2;
    private static Color m_activeColor = Color.gray;
    private static Font m_normalFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
    private static Font m_hoverFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
    private static Color m_normalColor = Color.black;
    private static Color m_hoverColor = GREEN;
    private static boolean m_normalUnderline = false;
    private static boolean m_hoverUnderline = true;

    public boolean equalTo(FtsEntry ftsEntry) {
        return this.getName().equals(ftsEntry.getName()) && ftsEntry.getFullURL().equals(this.getFullURL());
    }

    public int getPrevSpan() {
        return 0;
    }

    public static void setHoverUnderline(boolean bl) {
        m_hoverUnderline = bl;
    }

    public boolean isMainEntry() {
        return true;
    }

    public static void setNormalColor(Color color) {
        m_normalColor = color;
    }

    public static void setHoverFont(Font font) {
        if (font.getSize() != m_normalFont.getSize()) {
            m_hoverFont = new Font(font.getFamily(), font.getStyle(), m_normalFont.getSize());
            return;
        }
        m_hoverFont = font;
    }

    public FtsEntry(String string, String string2, FtsTData ftsTData) {
        super(string, string2);
        this.m_FtsData = ftsTData;
    }

    private URL getFullURL() {
        URL uRL = null;
        try {
            uRL = URLFileHandler.makeURL(this.m_FtsData.getProjURL(), this.getURL(), null);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public void select(boolean bl) {
        this.m_bSelect = bl;
    }

    public void copyFrom(FtsEntry ftsEntry) {
        FtsEntry ftsEntry2 = ftsEntry;
        super.copyFrom(ftsEntry2);
        this.m_FtsData = ftsEntry2.m_FtsData;
    }

    public static void setNormalFont(Font font) {
        m_normalFont = font;
    }

    public static void setNormalUnderline(boolean bl) {
        m_normalUnderline = bl;
    }

    public static void setActiveColor(Color color) {
        m_activeColor = color;
    }

    public void highLight(boolean bl) {
        this.m_bHighLight = bl;
    }

    public void action(IActionSink iActionSink) {
        URL uRL = this.getFullURL();
        Vector<URL> vector = new Vector<URL>();
        vector.addElement(uRL);
        iActionSink.accept(vector);
    }

    public int getNextSpan() {
        return 0;
    }

    public void display(Graphics graphics, int n, int n2, Color color, Image image) {
        int n3;
        Color color2 = graphics.getColor();
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(m_hoverFont);
        int n4 = fontMetrics.stringWidth(this.getName() + " ");
        n4 = n4 > (n3 = fontMetrics2.stringWidth(this.getName() + " ")) ? n4 : n3;
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getLeading();
        int n7 = fontMetrics2.getAscent();
        int n8 = fontMetrics2.getLeading();
        if (this.m_bSelect) {
            graphics.setColor(m_activeColor);
            graphics.fill3DRect(m_indent, n * n2, n4, n2, true);
        } else if (image != null) {
            graphics.drawImage(image, m_indent, n * n2, 2 + n4, n * n2 + n2, m_indent, n * n2, m_indent + n4, n * n2 + n2, null);
        } else {
            graphics.setColor(color);
            graphics.fillRect(m_indent, n * n2, n4, n2);
        }
        graphics.setColor(color2);
        Font font = graphics.getFont();
        if (this.m_bHighLight) {
            graphics.setColor(m_hoverColor);
            graphics.setFont(m_hoverFont);
            graphics.drawString(this.getName(), m_indent, n * n2 + n7 + n8);
            if (m_hoverUnderline) {
                graphics.drawLine(m_indent, (n + 1) * n2 - 1, m_indent + n4 - 1, (n + 1) * n2 - 1);
            }
            graphics.setColor(color2);
            graphics.setFont(font);
            return;
        }
        graphics.setColor(m_normalColor);
        graphics.setFont(m_normalFont);
        graphics.drawString(this.getName(), m_indent, n * n2 + n5 + n6);
        if (m_normalUnderline) {
            graphics.drawLine(m_indent, (n + 1) * n2 - 1, m_indent + n4 - 1, (n + 1) * n2 - 1);
        }
        graphics.setColor(color2);
        graphics.setFont(font);
    }

    public static void setIndent(int n) {
        m_indent = n;
    }

    public int getWidth(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        int n = fontMetrics.stringWidth(this.getName() + " ");
        return m_indent + n + 1;
    }

    public FtsEntry cloneEntry() {
        FtsEntry ftsEntry = null;
        try {
            ftsEntry = (FtsEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return ftsEntry;
    }

    public static void setHoverColor(Color color) {
        m_hoverColor = color;
    }
}

