/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public class CraftingUpgradeTweakProvider
implements CraftingGridProvider {
    public String getModId() {
        return "sophisticatedcore";
    }

    public boolean handles(class_1703 abstractContainerMenu) {
        return abstractContainerMenu instanceof StorageContainerMenuBase;
    }

    public void buildCraftingGrids(CraftingGridBuilder builder, class_1703 containerMenu) {
        if (!(containerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)containerMenu;
        builder.addGrid(CraftingUpgradeTweakProvider.getCraftingGridStart(storageContainer), CraftingUpgradeTweakProvider.getCraftingGridSize(storageContainer)).clearHandler((craftingGrid, player, menu, forced) -> this.clearGrid(player, menu, forced)).rotateHandler((craftingGrid, player, menu, reverse) -> this.rotateGrid(menu, reverse)).balanceHandler((GridBalanceHandler)new StorageCraftingGridBalanceHandler()).transferHandler((GridTransferHandler)new StorageCraftingGridTransferHandler()).hideAllTweakButtons();
    }

    public void clearGrid(class_1657 player, class_1703 menu, boolean forced) {
        if (!(menu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)menu;
        CraftingUpgradeTweakProvider.getCraftMatrix(storageContainer).ifPresent(craftMatrix -> {
            int start = CraftingUpgradeTweakProvider.getCraftingGridStart(storageContainer);
            int size = CraftingUpgradeTweakProvider.getCraftingGridSize(storageContainer);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = storageContainer.method_7611(i).method_34266();
                class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                if (itemStack.method_7960()) continue;
                class_1799 returnStack = itemStack.method_7972();
                player.method_31548().method_7394(returnStack);
                craftMatrix.method_5447(slotIndex, returnStack.method_7947() == 0 ? class_1799.field_8037 : returnStack);
                if (returnStack.method_7947() <= 0 || !forced) continue;
                player.method_7328(returnStack, false);
                craftMatrix.method_5447(slotIndex, class_1799.field_8037);
            }
            storageContainer.method_7623();
        });
    }

    private int rotateSlotId(int slotId, boolean counterClockwise) {
        if (!counterClockwise) {
            switch (slotId) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 0;
                }
                case 5: {
                    return 8;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 6;
                }
                case 8: {
                    return 7;
                }
            }
        } else {
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }

    private boolean ignoresSlotId(int slotId) {
        return slotId == 4;
    }

    private void rotateGrid(class_1703 containerMenu, boolean counterClockwise) {
        if (!(containerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)containerMenu;
        CraftingUpgradeTweakProvider.getCraftMatrix(storageContainer).ifPresent(craftMatrix -> {
            int slotIndex;
            int i;
            int start = CraftingUpgradeTweakProvider.getCraftingGridStart(storageContainer);
            int size = CraftingUpgradeTweakProvider.getCraftingGridSize(storageContainer);
            class_1277 matrixClone = new class_1277(size);
            for (i = 0; i < size; ++i) {
                slotIndex = storageContainer.method_7611(start + i).method_34266();
                matrixClone.method_5447(i, craftMatrix.method_5438(slotIndex));
            }
            for (i = 0; i < size; ++i) {
                if (this.ignoresSlotId(i)) continue;
                slotIndex = containerMenu.method_7611(start + this.rotateSlotId(i, counterClockwise)).method_34266();
                craftMatrix.method_5447(slotIndex, matrixClone.method_5438(i));
            }
            storageContainer.method_7623();
        });
    }

    private static Optional<class_1263> getCraftMatrix(StorageContainerMenuBase<?> container) {
        return CraftingUpgradeTweakProvider.getOpenCraftingContainer(container).map(ICraftingContainer::getCraftMatrix);
    }

    public boolean requiresServerSide() {
        return true;
    }

    private static Optional<ICraftingContainer> getOpenCraftingContainer(StorageContainerMenuBase<?> container) {
        return container.getOpenContainer().flatMap(c -> {
            Optional<Object> optional;
            if (c instanceof ICraftingContainer) {
                ICraftingContainer craftingContainer = (ICraftingContainer)((Object)c);
                optional = Optional.of(craftingContainer);
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
    }

    private static int getCraftingGridStart(StorageContainerMenuBase<?> container) {
        return CraftingUpgradeTweakProvider.getOpenCraftingContainer(container).map(cc -> {
            List<class_1735> recipeSlots = cc.getRecipeSlots();
            if (!recipeSlots.isEmpty()) {
                return recipeSlots.get((int)0).field_7874;
            }
            return 0;
        }).orElse(0);
    }

    private static int getCraftingGridSize(StorageContainerMenuBase<?> container) {
        return CraftingUpgradeTweakProvider.getOpenCraftingContainer(container).isPresent() ? 9 : 0;
    }

    private static class StorageCraftingGridBalanceHandler
    implements GridBalanceHandler<class_1703> {
        private StorageCraftingGridBalanceHandler() {
        }

        public void balanceGrid(CraftingGrid grid, class_1657 player, class_1703 menu) {
            if (!(menu instanceof StorageContainerMenuBase)) {
                return;
            }
            StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)menu;
            CraftingUpgradeTweakProvider.getCraftMatrix(storageContainer).ifPresent(craftMatrix -> {
                ArrayListMultimap itemMap = ArrayListMultimap.create();
                HashMultiset itemCount = HashMultiset.create();
                int start = CraftingUpgradeTweakProvider.getCraftingGridStart(storageContainer);
                int size = CraftingUpgradeTweakProvider.getCraftingGridSize(storageContainer);
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = menu.method_7611(i).method_34266();
                    class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                    if (itemStack.method_7960() || itemStack.method_7914() <= 1) continue;
                    class_2960 registryName = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
                    Object key = Objects.toString(registryName);
                    key = (String)key + "@" + String.valueOf(itemStack.method_57380());
                    itemMap.put(key, (Object)slotIndex);
                    itemCount.add(key, itemStack.method_7947());
                }
                for (String key : itemMap.keySet()) {
                    class_1799 itemStack;
                    int slotIndex;
                    List balanceList = itemMap.get((Object)key);
                    int totalCount = itemCount.count((Object)key);
                    int countPerStack = totalCount / balanceList.size();
                    int restCount = totalCount % balanceList.size();
                    Iterator iterator = balanceList.iterator();
                    while (iterator.hasNext()) {
                        slotIndex = (Integer)iterator.next();
                        itemStack = craftMatrix.method_5438(slotIndex);
                        itemStack.method_7939(countPerStack);
                        craftMatrix.method_5447(slotIndex, itemStack);
                    }
                    int idx = 0;
                    while (restCount > 0) {
                        slotIndex = (Integer)balanceList.get(idx);
                        itemStack = craftMatrix.method_5438(slotIndex);
                        if (itemStack.method_7947() < itemStack.method_7914()) {
                            itemStack.method_7933(1);
                            craftMatrix.method_5447(slotIndex, itemStack);
                            --restCount;
                        }
                        if (++idx < balanceList.size()) continue;
                        idx = 0;
                    }
                }
                menu.method_7623();
            });
        }

        public void spreadGrid(CraftingGrid grid, class_1657 player, class_1703 menu) {
            if (!(menu instanceof StorageContainerMenuBase)) {
                return;
            }
            StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)menu;
            CraftingUpgradeTweakProvider.getCraftMatrix(storageContainer).ifPresent(craftMatrix -> {
                boolean emptyBiggestSlot;
                do {
                    class_1799 biggestSlotStack = null;
                    int biggestSlotSize = 1;
                    int biggestSlotIndex = -1;
                    int start = CraftingUpgradeTweakProvider.getCraftingGridStart(storageContainer);
                    int size = CraftingUpgradeTweakProvider.getCraftingGridSize(storageContainer);
                    for (int i = start; i < start + size; ++i) {
                        int slotIndex = menu.method_7611(i).method_34266();
                        class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                        if (itemStack.method_7960() || itemStack.method_7947() <= biggestSlotSize) continue;
                        biggestSlotStack = itemStack;
                        biggestSlotSize = itemStack.method_7947();
                        biggestSlotIndex = slotIndex;
                    }
                    if (biggestSlotStack == null) {
                        return;
                    }
                    emptyBiggestSlot = false;
                    for (int i = start; i < start + size; ++i) {
                        int slotIndex = menu.method_7611(i).method_34266();
                        class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                        if (!itemStack.method_7960()) continue;
                        if (biggestSlotStack.method_7947() > 1) {
                            craftMatrix.method_5447(slotIndex, biggestSlotStack.method_7971(1));
                            craftMatrix.method_5447(biggestSlotIndex, biggestSlotStack);
                            continue;
                        }
                        emptyBiggestSlot = true;
                    }
                } while (emptyBiggestSlot);
                this.balanceGrid(grid, player, menu);
            });
        }
    }

    private static class StorageCraftingGridTransferHandler
    implements GridTransferHandler<class_1703> {
        private StorageCraftingGridTransferHandler() {
        }

        public class_1799 putIntoGrid(CraftingGrid craftingGrid, class_1657 player, class_1703 menu, int slotId, class_1799 itemStack) {
            if (!(menu instanceof StorageContainerMenuBase)) {
                return itemStack;
            }
            StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)menu;
            return CraftingUpgradeTweakProvider.getCraftMatrix(storageContainer).map(craftMatrix -> {
                class_1799 craftStack = craftMatrix.method_5438(slotId);
                if (!craftStack.method_7960()) {
                    int spaceLeft;
                    if (class_1799.method_31577((class_1799)craftStack, (class_1799)itemStack) && (spaceLeft = Math.min(craftMatrix.method_5444(), craftStack.method_7914()) - craftStack.method_7947()) > 0) {
                        class_1799 splitStack = itemStack.method_7971(Math.min(spaceLeft, itemStack.method_7947()));
                        craftStack.method_7933(splitStack.method_7947());
                        if (itemStack.method_7947() <= 0) {
                            return class_1799.field_8037;
                        }
                    }
                } else {
                    class_1799 transferStack = itemStack.method_7971(Math.min(itemStack.method_7947(), craftMatrix.method_5444()));
                    craftMatrix.method_5447(slotId, transferStack);
                }
                return itemStack.method_7947() <= 0 ? class_1799.field_8037 : itemStack;
            }).orElse(itemStack);
        }

        public boolean transferIntoGrid(CraftingGrid craftingGrid, class_1657 player, class_1703 menu, class_1735 fromSlot) {
            if (!(menu instanceof StorageContainerMenuBase)) {
                return false;
            }
            StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)menu;
            return CraftingUpgradeTweakProvider.getCraftMatrix(storageContainer).map(craftMatrix -> {
                int start = CraftingUpgradeTweakProvider.getCraftingGridStart(storageContainer);
                int size = CraftingUpgradeTweakProvider.getCraftingGridSize(storageContainer);
                class_1799 itemStack = fromSlot.method_7677();
                if (itemStack.method_7960()) {
                    return false;
                }
                int firstEmptySlot = -1;
                for (int i = start; i < start + size; ++i) {
                    int slotIndex = menu.method_7611(i).method_34266();
                    class_1799 craftStack = craftMatrix.method_5438(slotIndex);
                    if (!craftStack.method_7960()) {
                        int spaceLeft;
                        if (!class_1799.method_31577((class_1799)craftStack, (class_1799)itemStack) || (spaceLeft = Math.min(craftMatrix.method_5444(), craftStack.method_7914()) - craftStack.method_7947()) <= 0) continue;
                        class_1799 splitStack = itemStack.method_7971(Math.min(spaceLeft, itemStack.method_7947()));
                        craftStack.method_7933(splitStack.method_7947());
                        if (itemStack.method_7947() > 0) continue;
                        return true;
                    }
                    if (firstEmptySlot != -1) continue;
                    firstEmptySlot = slotIndex;
                }
                if (itemStack.method_7947() > 0 && firstEmptySlot != -1) {
                    class_1799 transferStack = itemStack.method_7971(Math.min(itemStack.method_7947(), craftMatrix.method_5444()));
                    craftMatrix.method_5447(firstEmptySlot, transferStack);
                    return true;
                }
                return false;
            }).orElse(false);
        }

        public boolean canTransferFrom(class_1657 player, class_1703 menu, class_1735 sourceSlot, CraftingGrid craftingGrid) {
            if (!(menu instanceof StorageContainerMenuBase)) {
                return false;
            }
            StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)menu;
            return sourceSlot.method_7674(player) && sourceSlot.field_7874 < storageContainer.realInventorySlots.size();
        }
    }
}

