/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import org.jetbrains.annotations.NotNull;

public class SimpleItemStackHandler
extends ItemStackHandler
implements IItemHandlerSimpleInserter {
    public SimpleItemStackHandler(int size) {
        super(size);
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    @Override
    public boolean isItemValid(int slot, ItemVariant resource, int count) {
        return true;
    }

    @Override
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (slot < 0 || slot >= this.getSlotCount()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlotCount() + ")");
        }
        class_1799 existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, ItemVariant.of((class_1799)stack));
        if (!existing.method_7960()) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            class_1799 result;
            if (existing.method_7960()) {
                result = reachedLimit ? stack.method_46651(limit) : stack;
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
                result = existing;
            }
            this.setStackInSlot(slot, result);
        }
        return reachedLimit ? stack.method_46651(stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate) {
        class_1799 remaining = stack;
        for (int slot = 0; slot < this.getSlotCount(); ++slot) {
            if (!(remaining = this.insertItem(slot, remaining, simulate)).method_7960()) continue;
            return remaining;
        }
        return remaining;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        class_1799 existing = this.getStackInSlot(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, class_1799.field_8037);
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            this.setStackInSlot(slot, existing.method_46651(existing.method_7947() - toExtract));
        }
        return existing.method_46651(toExtract);
    }
}

