/*
 * Decompiled with CFR 0.152.
 */
package net.kikoz.mcwfences.objects;

import java.util.HashMap;
import java.util.Map;
import net.kikoz.mcwfences.objects.DoubleGate;
import net.kikoz.mcwfences.objects.FenceHitbox;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2544;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class MetalFence
extends class_2248 {
    public static final class_2746 NORTH = class_2746.method_11825((String)"north");
    public static final class_2746 SOUTH = class_2746.method_11825((String)"south");
    public static final class_2746 EAST = class_2746.method_11825((String)"east");
    public static final class_2746 WEST = class_2746.method_11825((String)"west");
    public static final class_2754<FencePart> PART = class_2754.method_11849((String)"fencepart", FencePart.class, (Enum[])new FencePart[]{FencePart.TOP, FencePart.BOTTOM});
    private static final class_265 POST = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);
    private static final class_265 POST_COLLISION = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0);
    private static final class_265 NORTH_SHAPE_COLLISION = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)6.0);
    private static final class_265 SOUTH_SHAPE_COLLISION = class_2248.method_9541((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)24.0, (double)16.0);
    private static final class_265 EAST_SHAPE_COLLISION = class_2248.method_9541((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    private static final class_265 WEST_SHAPE_COLLISION = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)24.0, (double)10.0);
    private static final Map<class_2680, class_265> SHAPE_CACHE = new HashMap<class_2680, class_265>();
    private static final Map<class_2680, class_265> COLLISION_SHAPE_CACHE = new HashMap<class_2680, class_265>();

    public MetalFence(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)((Object)FencePart.TOP)));
    }

    private class_2680 FenceState(class_2680 state, class_1936 level, class_2338 pos) {
        boolean above = level.method_8320(pos.method_10084()).method_26204() == this;
        boolean below = level.method_8320(pos.method_10074()).method_26204() == this;
        FencePart connection = this.getConnectionStatus(above, below);
        return (class_2680)state.method_11657(PART, (Comparable)((Object)connection));
    }

    private FencePart getConnectionStatus(boolean above, boolean below) {
        if (!above) {
            return FencePart.TOP;
        }
        return FencePart.BOTTOM;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 statetwo, boolean moved) {
        if (state.method_26204() == statetwo.method_26204()) {
            level.method_8652(pos, statetwo, 2);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2680 northState = level.method_8320(pos.method_10095());
        class_2680 southState = level.method_8320(pos.method_10072());
        class_2680 eastState = level.method_8320(pos.method_10078());
        class_2680 westState = level.method_8320(pos.method_10067());
        boolean northConnects = this.canConnect(northState, northState.method_26206((class_1922)level, pos.method_10095(), class_2350.field_11035), class_2350.field_11035);
        boolean southConnects = this.canConnect(southState, southState.method_26206((class_1922)level, pos.method_10072(), class_2350.field_11043), class_2350.field_11043);
        boolean eastConnects = this.canConnect(eastState, eastState.method_26206((class_1922)level, pos.method_10078(), class_2350.field_11039), class_2350.field_11039);
        boolean westConnects = this.canConnect(westState, westState.method_26206((class_1922)level, pos.method_10067(), class_2350.field_11034), class_2350.field_11034);
        return this.FenceState((class_2680)((class_2680)((class_2680)((class_2680)super.method_9605(context).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(northConnects))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(southConnects))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(eastConnects))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(westConnects)), (class_1936)level, pos);
    }

    public void placeAt(class_1936 world, class_2680 state, class_2338 pos, int flags) {
        world.method_8652(pos, this.method_9564(), flags);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_CACHE.computeIfAbsent(state, this::computeShape);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPE_CACHE.computeIfAbsent(state, this::computeCollision);
    }

    private class_265 computeShape(class_2680 state) {
        class_265 shape = POST;
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)NORTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SOUTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)EAST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)WEST_SHAPE);
        }
        return shape;
    }

    private class_265 computeCollision(class_2680 state) {
        class_265 shape = POST_COLLISION;
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)NORTH_SHAPE_COLLISION);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SOUTH_SHAPE_COLLISION);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)EAST_SHAPE_COLLISION);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)WEST_SHAPE_COLLISION);
        }
        return shape;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2746 property;
        if (direction.method_10166().method_10179() && (property = this.getProperty(direction)) != null) {
            boolean isNeighborSturdy = neighborState.method_26206((class_1922)level, neighborPos, direction.method_10153());
            boolean connects = neighborState.method_26215() ? false : this.canConnect(neighborState, isNeighborSturdy, direction);
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(connects));
        }
        boolean above = level.method_8320(pos.method_10084()).method_26204() == this;
        boolean below = level.method_8320(pos.method_10074()).method_26204() == this;
        FencePart connection = this.getConnectionStatus(above, below);
        state = (class_2680)state.method_11657(PART, (Comparable)((Object)connection));
        return state;
    }

    public boolean canConnect(class_2680 state, boolean bool, class_2350 dir) {
        class_2248 block = state.method_26204();
        boolean flag = this.isSameFence(state);
        boolean flag1 = block instanceof class_2349 && class_2349.method_16703((class_2680)state, (class_2350)dir);
        boolean flag2 = block instanceof class_2544;
        boolean flag3 = block instanceof FenceHitbox;
        boolean flag4 = block instanceof DoubleGate;
        boolean flag5 = block instanceof class_2349;
        boolean flag6 = block instanceof class_2354;
        return !MetalFence.method_9581((class_2680)state) && bool || flag || flag1 || flag2 || flag3 || flag4 || flag5 || flag6;
    }

    private boolean isSameFence(class_2680 state) {
        return state.method_26164(class_3481.field_16584) && state.method_26164(class_3481.field_17619) == this.method_9564().method_26164(class_3481.field_17619);
    }

    private class_2746 getProperty(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11039 -> WEST;
            default -> null;
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, SOUTH, EAST, WEST, PART});
    }

    public static enum FencePart implements class_3542
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private FencePart(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

