/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.animation.AzAnimationContext;
import mod.azure.azurelibarmor.common.animation.AzAnimator;
import mod.azure.azurelibarmor.common.animation.AzAnimatorAccessor;
import mod.azure.azurelibarmor.common.animation.cache.AzBoneCache;
import mod.azure.azurelibarmor.common.model.AzBakedModel;
import mod.azure.azurelibarmor.common.model.cache.AzBakedModelCache;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzProvider<K, T> {
    protected final Supplier<AzAnimator<K, T>> animatorSupplier;
    protected final BiFunction<class_1297, T, class_2960> modelLocationProvider;
    protected final Function<T, K> UUIDProvider;

    public AzProvider(Supplier<AzAnimator<K, T>> animatorSupplier, BiFunction<class_1297, T, class_2960> modelLocationProvider, Function<T, K> UUIDProvider) {
        this.animatorSupplier = animatorSupplier;
        this.modelLocationProvider = modelLocationProvider;
        this.UUIDProvider = UUIDProvider;
    }

    @Nullable
    public AzBakedModel provideBakedModel(@Nullable class_1297 entity, @NotNull T animatable) {
        class_2960 modelLocation = this.modelLocationProvider.apply(entity, (class_1297)animatable);
        AzBakedModel shared = AzBakedModelCache.getInstance().getNullable(modelLocation);
        if (shared == null) {
            return AzBakedModel.getDefault();
        }
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator == null) {
            return shared;
        }
        AzAnimationContext<T> ctx = animator.context();
        AzBoneCache cache = ctx.boneCache();
        if (cache == null || cache.isEmpty()) {
            return shared;
        }
        return cache.getBakedModel();
    }

    @Nullable
    public AzAnimator<K, T> provideAnimator(@Nullable class_1297 entity, T animatable) {
        AzAnimatorAccessor accessor = AzAnimatorAccessor.cast(animatable);
        AzAnimator<K, T> cachedAnimator = accessor.getAnimatorOrNull();
        class_2960 modelLocation = this.modelLocationProvider.apply(entity, (class_1297)animatable);
        AzBakedModel shared = AzBakedModelCache.getInstance().getNullable(modelLocation);
        if (cachedAnimator == null) {
            cachedAnimator = this.animatorSupplier.get();
            if (cachedAnimator != null) {
                AzAnimationContext<T> ctx = cachedAnimator.getOrCreateContext(this.UUIDProvider.apply(animatable));
                if (shared != null) {
                    ctx.boneCache().setActiveModel(shared);
                }
                cachedAnimator.registerControllers(cachedAnimator.getAnimationControllerContainer());
                accessor.setAnimator(cachedAnimator);
            }
        } else {
            AzBakedModel baked;
            AzAnimationContext<T> ctx = cachedAnimator.context();
            if (ctx != null && shared != null && !(baked = ctx.boneCache().getBakedModel()).equals(shared)) {
                ctx.boneCache().setActiveModel(shared);
            }
        }
        return cachedAnimator;
    }
}

