/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.packet.s2c.OpenChooseOriginScreenS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.registry.ModComponents;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import org.jetbrains.annotations.Nullable;

public class ItemOriginsComponent
implements class_9299 {
    public static final ItemOriginsComponent DEFAULT = new ItemOriginsComponent((Collection<Entry>)new ObjectLinkedOpenHashSet());
    public static final Codec<ItemOriginsComponent> CODEC = Entry.SET_CODEC.xmap(ItemOriginsComponent::new, ItemOriginsComponent::entries);
    public static final class_9139<class_2540, ItemOriginsComponent> PACKET_CODEC = class_9135.method_56376(ObjectLinkedOpenHashSet::new, Entry.PACKET_CODEC).method_56432(ItemOriginsComponent::new, ItemOriginsComponent::entries);
    final ObjectLinkedOpenHashSet<Entry> entries;

    ItemOriginsComponent(Collection<Entry> entries) {
        this.entries = new ObjectLinkedOpenHashSet(entries);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        String baseKey = "component.item.origins.origin";
        boolean appendedTooltips = false;
        for (Entry entry : this.entries()) {
            Object[] args;
            String translationKey;
            Origin origin;
            OriginLayer layer = OriginLayerManager.getNullable(entry.layerId());
            if (!ItemOriginsComponent.canSet(layer, origin = OriginManager.getNullable(entry.originId()))) continue;
            if (origin == Origin.EMPTY) {
                translationKey = baseKey + ".layer";
                args = new Object[]{layer.getName()};
            } else {
                translationKey = baseKey + ".layer_and_origin";
                args = new Object[]{layer.getName(), origin.getName()};
            }
            tooltip.accept((class_2561)class_2561.method_43469((String)translationKey, (Object[])args).method_27692(class_124.field_1080));
            appendedTooltips = true;
        }
        if (!appendedTooltips) {
            tooltip.accept((class_2561)class_2561.method_43471((String)(baseKey + ".generic")).method_27692(class_124.field_1080));
        }
    }

    private ObjectLinkedOpenHashSet<Entry> entries() {
        return this.entries;
    }

    public boolean setOrigin(class_1309 user) {
        if (!(user instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)user;
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        boolean assignedOrigin = this.entries().stream().map(entry -> entry.set(originComponent)).reduce(false, Boolean::logicalOr);
        if (!assignedOrigin) {
            OriginLayerManager.values().stream().filter(OriginLayer::isEnabled).forEach(layer -> originComponent.setOrigin((OriginLayer)layer, Origin.EMPTY));
        }
        int originOptions = OriginLayerManager.getOriginOptionCount((class_1657)player);
        originComponent.selectingOrigin(!(assignedOrigin |= originComponent.checkAutoChoosingLayers((class_1657)player, false)) || originOptions > 0);
        originComponent.sync();
        if (originComponent.isSelectingOrigin()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenChooseOriginScreenS2CPacket(false));
        }
        return assignedOrigin || originComponent.isSelectingOrigin();
    }

    public static boolean canSet(@Nullable OriginLayer layer, @Nullable Origin origin) {
        return layer != null && origin != null && layer.isEnabled() && (layer.contains(origin) || origin.isSpecial());
    }

    public record Entry(class_2960 layerId, class_2960 originId) {
        public static final MapCodec<Entry> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("layer").forGetter(Entry::layerId), (App)class_2960.field_25139.optionalFieldOf("origin", (Object)Origin.EMPTY.getId()).forGetter(Entry::originId)).apply((Applicative)instance, Entry::new));
        public static final class_9139<class_2540, Entry> PACKET_CODEC = class_9139.method_56435((class_9139)class_2960.field_48267, Entry::layerId, (class_9139)class_2960.field_48267, Entry::originId, Entry::new);
        public static final Codec<Set<Entry>> SET_CODEC = MAP_CODEC.codec().listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf);

        public boolean set(OriginComponent originComponent) {
            Origin origin = OriginManager.getNullable(this.originId());
            OriginLayer layer = OriginLayerManager.getNullable(this.layerId());
            if (ItemOriginsComponent.canSet(layer, origin)) {
                originComponent.setOrigin(layer, origin);
                return true;
            }
            return false;
        }
    }
}

