/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.condition.entity.type;

import io.github.apace100.apoli.condition.ConditionConfiguration;
import io.github.apace100.apoli.condition.context.EntityConditionContext;
import io.github.apace100.apoli.condition.type.EntityConditionType;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.condition.factory.entity.OriginsEntityConditionTypes;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.registry.ModComponents;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class OriginEntityConditionType
extends EntityConditionType {
    public static final TypedDataObjectFactory<OriginEntityConditionType> DATA_FACTORY = TypedDataObjectFactory.simple((SerializableData)new SerializableData().add("origin", SerializableDataTypes.IDENTIFIER).add("layer", SerializableDataTypes.IDENTIFIER.optional(), Optional.empty()), data -> new OriginEntityConditionType((class_2960)data.get("origin"), (Optional)data.get("layer")), (conditionType, serializableData) -> serializableData.instance().set("origin", (Object)conditionType.originId).set("layer", conditionType.layerId));
    private final class_2960 originId;
    private final Optional<class_2960> layerId;

    public OriginEntityConditionType(class_2960 originId, Optional<class_2960> layerId) {
        this.originId = originId;
        this.layerId = layerId;
    }

    public boolean test(EntityConditionContext context) {
        class_1297 entity = context.entity();
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.getNullable((Object)entity);
        if (originComponent == null) {
            return false;
        }
        return this.layerId.flatMap(OriginLayerManager::getOptional).map(originComponent::getOrigin).map(Origin::getId).map(arg_0 -> ((class_2960)this.originId).equals(arg_0)).orElseGet(() -> originComponent.getOrigins().values().stream().map(Origin::getId).anyMatch(arg_0 -> ((class_2960)this.originId).equals(arg_0)));
    }

    @NotNull
    public ConditionConfiguration<?> getConfig() {
        return OriginsEntityConditionTypes.ORIGIN;
    }
}

