/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.MultiplePower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerReference;
import io.github.apace100.apoli.util.TextUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.calio.util.Validatable;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.data.OriginsDataTypes;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.registry.ModComponents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8779;
import org.jetbrains.annotations.Nullable;

public class Origin
implements Validatable {
    public static final Origin EMPTY = Origin.special(Origins.identifier("empty"), class_1799.field_8037, Impact.NONE, Integer.MAX_VALUE);
    public static final SerializableDataType<Origin> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("id", SerializableDataTypes.IDENTIFIER).add("icon", SerializableDataTypes.UNCOUNTED_ITEM_STACK, (Object)class_1799.field_8037).add("powers", ApoliDataTypes.POWER_REFERENCE.list(), (Object)new ObjectArrayList()).add("upgrades", OriginsDataTypes.UPGRADES, (Object)new ObjectArrayList()).add("impact", OriginsDataTypes.IMPACT, (Object)Impact.NONE).add("name", SerializableDataTypes.TEXT, null).add("description", SerializableDataTypes.TEXT, null).add("unchoosable", SerializableDataTypes.BOOLEAN, (Object)false).add("order", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE), data -> new Origin((class_2960)data.get("id"), (class_1799)data.get("icon"), (List)data.get("powers"), (List)data.get("upgrades"), (Impact)((Object)((Object)data.get("impact"))), (class_2561)data.get("name"), (class_2561)data.get("description"), (Boolean)data.get("unchoosable"), (Integer)data.get("order")), (origin, serializableData) -> serializableData.instance().set("id", (Object)origin.getId()).set("icon", (Object)origin.getDisplayItem()).set("powers", origin.getPowerReferences()).set("upgrades", origin.upgrades).set("impact", (Object)origin.getImpact()).set("name", (Object)origin.getName()).set("description", (Object)origin.getDescription()).set("unchoosable", (Object)(!origin.isChoosable() ? 1 : 0)).set("special", (Object)origin.isSpecial()).set("order", (Object)origin.getOrder()));
    private final class_2960 id;
    private final class_1799 displayItem;
    private final Set<PowerReference> powerReferences;
    private final Set<Power> powers;
    private final List<OriginUpgrade> upgrades;
    private final Impact impact;
    private final class_2561 name;
    private final class_2561 description;
    private final boolean choosable;
    private final boolean special;
    private final int order;

    protected Origin(class_2960 id, class_1799 icon, List<PowerReference> powerReferences, List<OriginUpgrade> upgrades, Impact impact, @Nullable class_2561 name, @Nullable class_2561 description, boolean unchoosable, boolean special, int order) {
        this.id = id;
        String baseTranslationKey = class_156.method_646((String)"origin", (class_2960)id);
        this.displayItem = icon.method_7972();
        this.powerReferences = new ObjectLinkedOpenHashSet(powerReferences);
        this.powers = new ObjectLinkedOpenHashSet();
        this.upgrades = upgrades;
        this.impact = impact;
        this.name = TextUtil.forceTranslatable((String)(baseTranslationKey + ".name"), Optional.ofNullable(name));
        this.description = TextUtil.forceTranslatable((String)(baseTranslationKey + ".description"), Optional.ofNullable(description));
        this.choosable = !unchoosable;
        this.special = special;
        this.order = order;
    }

    public Origin(class_2960 id, class_1799 icon, List<PowerReference> powerReferences, List<OriginUpgrade> upgrades, Impact impact, @Nullable class_2561 name, @Nullable class_2561 description, boolean unchoosable, int order) {
        this(id, icon, powerReferences, upgrades, impact, name, description, unchoosable, false, order);
    }

    public static Origin special(class_2960 id, class_1799 icon, Impact impact, int order) {
        return new Origin(id, icon, new LinkedList<PowerReference>(), new LinkedList<OriginUpgrade>(), impact, null, null, true, true, order);
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public ImmutableList<PowerReference> getPowerReferences() {
        return ImmutableList.copyOf(this.powerReferences);
    }

    public ImmutableList<Power> getPowers() {
        return ImmutableList.copyOf(this.powers);
    }

    @Deprecated(forRemoval=true)
    public Optional<OriginUpgrade> getUpgrade(class_8779 advancement) {
        return this.upgrades.stream().filter(ou -> ou.advancementCondition().equals((Object)advancement.comp_1919())).findFirst();
    }

    @Deprecated(forRemoval=true)
    public boolean hasUpgrade() {
        return !this.upgrades.isEmpty();
    }

    public Impact getImpact() {
        return this.impact;
    }

    public class_5250 getName() {
        return this.name.method_27661();
    }

    public class_5250 getDescription() {
        return this.description.method_27661();
    }

    public boolean isChoosable() {
        return this.choosable;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int getOrder() {
        return this.order;
    }

    public void validate() {
        this.powers.clear();
        for (PowerReference powerReference : this.powerReferences) {
            try {
                this.powers.add(powerReference.getPower());
            }
            catch (Exception e) {
                Origins.LOGGER.error("Origin \"{}\" contained unregistered power \"{}\"!", (Object)this.id, (Object)powerReference.id());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPower(Power targetPower) {
        if (this.powers.contains(targetPower)) return true;
        if (!this.powers.stream().filter(MultiplePower.class::isInstance).map(MultiplePower.class::cast).map(MultiplePower::getSubPowerIds).flatMap(Collection::stream).anyMatch(arg_0 -> ((class_2960)targetPower.getId()).equals(arg_0))) return false;
        return true;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Origin[id = " + this.id.toString() + ", powers = {");
        String separator = "";
        for (Power power : this.powers) {
            str.append(separator).append(power.getId());
            separator = ", ";
        }
        str.append("}]");
        return str.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Origin)) return false;
        Origin other = (Origin)obj;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    public static void init() {
    }

    public static Map<OriginLayer, Origin> get(class_1297 entity) {
        if (entity instanceof class_1657) {
            return Origin.get((class_1657)entity);
        }
        return new HashMap<OriginLayer, Origin>();
    }

    public static Map<OriginLayer, Origin> get(class_1657 player) {
        return ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getOrigins();
    }
}

