/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.upcraft.sparkweave.api.platform.Services;
import dev.upcraft.sparkweave.api.platform.services.SparkweaveHelperService;
import java.nio.file.Path;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class CommandHelper {
    private static final SparkweaveHelperService HELPER = Services.getService(SparkweaveHelperService.class);
    public static final DynamicCommandExceptionType IO_EXCEPTION = new DynamicCommandExceptionType(ex -> {
        Object object;
        Object[] objectArray = new Object[1];
        if (ex instanceof Throwable) {
            Throwable t = (Throwable)ex;
            object = t.getMessage();
        } else {
            object = ex;
        }
        objectArray[0] = object;
        return class_2561.method_43469((String)"commands.sparkweave.error.io_exception", (Object[])objectArray);
    });

    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>> class_2314<A, T> createArgumentInfo(Class<A> clazz, class_2314<A, T> info) {
        return HELPER.create(clazz, info);
    }

    public static void sendPathResult(CommandContext<class_2168> ctx, Path location, Supplier<class_2561> baseMessage, UnaryOperator<class_2561> pathMessage) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        if (player != null && server.method_19466(player.method_7334())) {
            String locationString = location.toAbsolutePath().toString();
            class_5250 pathComponent = class_2561.method_43470((String)locationString).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1078, class_124.field_1073}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.sparkweave.open_folder"))).method_10958(new class_2558(class_2558.class_2559.field_11746, locationString)));
            if (!((class_2168)ctx.getSource()).method_54882()) {
                player.method_43496((class_2561)pathMessage.apply((class_2561)pathComponent));
            }
            CommandHelper.broadcastToAdmins(server, baseMessage.get(), player.method_7334().getId());
        } else {
            ((class_2168)ctx.getSource()).method_45068(baseMessage.get());
            CommandHelper.broadcastToAdmins(server, baseMessage.get(), new UUID[0]);
        }
    }

    public static void broadcastToAdmins(MinecraftServer server, class_2561 message, UUID ... exclude) {
        CommandHelper.broadcastToAdmins(server, message, false, exclude);
    }

    public static void broadcastToAdmins(MinecraftServer server, class_2561 message, boolean ignoreSendCommandFeedback, UUID ... exclude) {
        Set<UUID> excludeSet = Set.of(exclude);
        if (ignoreSendCommandFeedback || server.method_3767().method_8355(class_1928.field_19400)) {
            for (class_3222 serverPlayer : server.method_3760().method_14571()) {
                GameProfile profile = serverPlayer.method_7334();
                if (!server.method_3760().method_14569(serverPlayer.method_7334()) || excludeSet.contains(profile.getId())) continue;
                serverPlayer.method_43496(message);
            }
        }
    }
}

