/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.platform;

import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.services.PlatformService;
import java.util.ServiceLoader;
import org.apache.logging.log4j.Logger;

public class Services {
    private static final Logger LOGGER = SparkweaveLoggerFactory.getLogger("Sparkweave Engine/ServiceLoader");
    public static final PlatformService PLATFORM = Services.getService(PlatformService.class);

    public static <T> T getService(Class<T> serviceClass) {
        T service = ServiceLoader.load(serviceClass).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + serviceClass.getName()));
        LOGGER.debug("Loaded {} for service {}", (Object)service.getClass().getName(), (Object)serviceClass.getName());
        return service;
    }
}

