/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.fabric.entrypoint;

import dev.upcraft.sparkweave.api.datagen.provider.SparkweaveDynamicRegistryEntryProvider;
import dev.upcraft.sparkweave.api.entrypoint.DataGenerationEntryPoint;
import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import dev.upcraft.sparkweave.datagen.DynamicRegistryBuilderImpl;
import dev.upcraft.sparkweave.entrypoint.EntrypointHelper;
import dev.upcraft.sparkweave.fabric.impl.datagen.FabricBuiltinEntriesProvider;
import dev.upcraft.sparkweave.fabric.impl.datagen.FabricDataGenerationContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_156;
import net.minecraft.class_7877;
import org.apache.logging.log4j.Logger;

public class DataGenerator
implements DataGeneratorEntrypoint {
    private static final Set<String> ENABLED_MODS = (Set)class_156.method_656(() -> {
        TreeSet<String> modIDs = new TreeSet<String>(Arrays.asList(System.getProperty("sparkweave.datagen.mods", "").strip().split(",\\s*")));
        if (modIDs.isEmpty()) {
            throw new IllegalArgumentException("[Sparkweave] sparkweave.datagen.mods property was empty or not set! please define which mod(s) to generate data for, as a comma-separated list!");
        }
        if (modIDs.size() != 1) {
            modIDs.remove("sparkweave");
        }
        return Collections.unmodifiableSet(modIDs);
    });
    private final Map<ModContainer, List<SparkweaveDynamicRegistryEntryProvider>> dynamicProviders = Collections.synchronizedMap(new LinkedHashMap());
    private class_7877 registrySetBuilder;
    private static final Logger LOGGER = SparkweaveLoggerFactory.getLogger();

    public void buildRegistry(class_7877 registryBuilder) {
        this.registrySetBuilder = registryBuilder;
        EntrypointHelper.fireEntrypoints(DataGenerationEntryPoint.class, (dataGenerator, contextModContainer) -> {
            if (ENABLED_MODS.contains(contextModContainer.metadata().id())) {
                LOGGER.info("Gathering dynamic registry data for {}", (Object)contextModContainer.metadata().displayName());
                DynamicRegistryBuilderImpl dynamicRegistryBuilder = new DynamicRegistryBuilderImpl((ModContainer)contextModContainer, registryBuilder);
                dataGenerator.generateDynamicRegistryEntries(dynamicRegistryBuilder);
                this.dynamicProviders.put((ModContainer)contextModContainer, dynamicRegistryBuilder.getProviders());
            }
        });
    }

    public void onInitializeDataGenerator(FabricDataGenerator fabricGenerator) {
        CompletableFuture registriesFuture = fabricGenerator.getRegistries();
        registriesFuture.join();
        FabricDataGenerator.Pack defaultPack = fabricGenerator.createPack();
        boolean strictValidation = fabricGenerator.isStrictValidationEnabled();
        defaultPack.addProvider((output, registriesFuture1) -> new FabricBuiltinEntriesProvider(output, registriesFuture1, this.registrySetBuilder, ENABLED_MODS, this.dynamicProviders));
        EntrypointHelper.fireEntrypoints(DataGenerationEntryPoint.class, (dataGenerator, contextModContainer) -> {
            if (ENABLED_MODS.contains(contextModContainer.metadata().id())) {
                LOGGER.info("Generating data for {}", (Object)contextModContainer.metadata().displayName());
                FabricDataGenerationContext ctx = new FabricDataGenerationContext((ModContainer)contextModContainer, strictValidation, defaultPack, registriesFuture, this.dynamicProviders.get(contextModContainer));
                dataGenerator.generate(ctx);
            }
        });
    }
}

