/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.fabric.impl.registry;

import dev.upcraft.sparkweave.api.registry.RegistryHelper;
import dev.upcraft.sparkweave.api.registry.RegistrySupplier;
import dev.upcraft.sparkweave.fabric.impl.registry.FabricRegistryHack;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FabricRegistrySupplier<R, T extends R>
implements RegistrySupplier<T> {
    private final class_5321<? super T> id;
    private final Supplier<T> factory;
    @Nullable
    private class_6880<R> holder;
    @Nullable
    private T value;
    private class_2378<R> registry;

    public FabricRegistrySupplier(class_5321<? super T> id, Supplier<T> factory) {
        this.id = id;
        this.factory = factory;
    }

    private T getOrCreateObject() {
        if (this.value == null) {
            this.value = Objects.requireNonNull(this.factory.get(), "factory returned null for " + String.valueOf(this.id));
        }
        return this.value;
    }

    public void register(class_2378<R> registry) {
        this.registry = registry;
        T object = this.getOrCreateObject();
        class_2378.method_39197(registry, this.getRegistryKey(), object);
        class_6880.class_6883 entryHolder = registry.method_40290(this.getRegistryKey());
        if (entryHolder instanceof class_6880.class_6883) {
            class_6880.class_6883 reference = entryHolder;
            if (reference.field_36451 != class_6880.class_6883.class_6884.field_36455 || reference.field_36453 == null) {
                reference.method_45918(this.value);
            }
        }
        this.holder = entryHolder;
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.value = Objects.requireNonNull(this.getRegistry().method_10223(this.id.method_29177()), "Registry supplier called too early: " + String.valueOf(this.getId()));
        }
        return this.value;
    }

    @Override
    public boolean is(T other) {
        return this.get() == other;
    }

    @Override
    public boolean matches(class_6862<? super T> tag) {
        return this.holder().method_40220(tag);
    }

    @Override
    public class_2960 getId() {
        return this.id.method_29177();
    }

    @Override
    public class_5321<R> getRegistryKey() {
        return this.id;
    }

    @Override
    public class_2378<R> getRegistry() {
        if (this.registry == null) {
            this.registry = RegistryHelper.getBuiltinRegistry(class_5321.method_29180((class_2960)this.id.method_41185()));
        }
        return this.registry;
    }

    @Override
    public class_6880<R> holder() {
        if (this.holder == null) {
            this.holder = (class_6880)this.registry.method_40264(this.getRegistryKey()).orElseGet(() -> {
                if (this.registry instanceof FabricRegistryHack) {
                    return ((FabricRegistryHack)this.registry).sparkweave$createHolder(this.getRegistryKey(), this::getOrCreateObject);
                }
                throw new IllegalStateException("Unable to create holder for entry %s because registry is not a mapped registry!".formatted(this.getRegistryKey()));
            });
        }
        return this.holder;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FabricRegistrySupplier) {
            FabricRegistrySupplier other = (FabricRegistrySupplier)obj;
            return this.getRegistryKey() == other.getRegistryKey();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id.method_41185(), this.id.method_29177());
    }
}

