/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.platform;

import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DotEnv {
    public static void load(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            System.getProperties().load(reader);
        }
        catch (IOException e) {
            SparkweaveLoggerFactory.getLogger("Sparkweave Engine/Env").error("Unable to load env file: {}", (Object)path.toAbsolutePath(), (Object)e);
        }
    }

    public static void load() {
        DotEnv.load(Path.of(".env", new String[0]));
        DotEnv.load(Path.of(String.format("%s.env", new Object[]{Services.PLATFORM.getEnvironmentType()}), new String[0]));
        DotEnv.load(Path.of(String.format("%s.%s.env", new Object[]{Services.PLATFORM.getEnvironmentType(), Services.PLATFORM.getEnvString()}), new String[0]));
    }
}

