/*
 * Decompiled with CFR 0.152.
 */
package com.kio7po.originsfurs.fabric.client;

import com.kio7po.originsfurs.fabric.client.registry.OriginFurRegistry;
import io.github.apace100.origins.origin.OriginManager;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class OriginsFursClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Origins Furs");

    public void onInitializeClient() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"originsfurs", (String)"furs");
            }

            public void method_14491(class_3300 manager) {
                OriginFurRegistry.clear();
                Map resources = manager.method_14488("furs", identifier -> identifier.method_12832().endsWith(".json"));
                for (class_2960 resourceId : resources.keySet()) {
                    String path = resourceId.method_12832();
                    LOGGER.info("[Origins Furs] Loading resource " + path);
                    String[] parts = path.split("/", 3);
                    if (parts.length != 3) {
                        LOGGER.warn("[Origins Furs] Incorrect path for Fur: " + path + ". Should be /furs/<mod_name>/<origin_name>.json. It will be ignored.");
                        continue;
                    }
                    String modname = parts[1];
                    String filename = parts[2].substring(0, parts[2].lastIndexOf(46));
                    class_2960 originId = class_2960.method_60655((String)modname, (String)filename);
                    OriginFurRegistry.registerResource(originId, (class_3298)resources.get(resourceId));
                    LOGGER.info("[Origins Furs] Registered resource " + String.valueOf(resourceId) + " with ID " + String.valueOf(originId));
                }
                OriginFurRegistry.loadFursFromOrigins(OriginManager.entrySet());
            }
        });
    }
}

