/*
 * Decompiled with CFR 0.152.
 */
package com.kio7po.originsfurs.fabric.client.feature;

import com.kio7po.originsfurs.fabric.client.bridge.IPlayerEntity;
import com.kio7po.originsfurs.fabric.client.bridge.IPlayerEntityModel;
import com.kio7po.originsfurs.fabric.client.model.OriginFur;
import com.kio7po.originsfurs.fabric.client.model.OriginFurAnimatable;
import com.kio7po.originsfurs.fabric.client.model.OriginFurModel;
import com.kio7po.originsfurs.fabric.client.util.Alib;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

@Environment(value=EnvType.CLIENT)
public class FurFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private GeoBone head;
    private GeoBone body;
    private GeoBone rightArm;
    private GeoBone leftArm;
    private GeoBone rightLeg;
    private GeoBone leftLeg;

    public FurFeatureRenderer(class_1007 renderer) {
        super((class_3883)renderer);
    }

    private void grabRelevantBones(OriginFurModel model) {
        this.head = model.getCachedGeoBone("bipedHead");
        this.body = model.getCachedGeoBone("bipedBody");
        this.rightArm = model.getCachedGeoBone("bipedRightArm");
        this.leftArm = model.getCachedGeoBone("bipedLeftArm");
        this.rightLeg = model.getCachedGeoBone("bipedRightLeg");
        this.leftLeg = model.getCachedGeoBone("bipedLeftLeg");
    }

    private void copyScale(class_630 from, GeoBone to) {
        to.updateScale(from.field_37938, from.field_37939, from.field_37940);
    }

    private void applyBaseTransformations(class_572<?> baseModel) {
        if (this.head != null) {
            class_630 headPart = baseModel.field_3398;
            RenderUtil.matchModelPartRot((class_630)headPart, (GeoBone)this.head);
            this.head.updatePosition(headPart.field_3657, -headPart.field_3656, headPart.field_3655);
            this.copyScale(headPart, this.head);
        }
        if (this.body != null) {
            class_630 bodyPart = baseModel.field_3391;
            RenderUtil.matchModelPartRot((class_630)bodyPart, (GeoBone)this.body);
            this.body.updatePosition(bodyPart.field_3657, -bodyPart.field_3656, bodyPart.field_3655);
            this.copyScale(bodyPart, this.body);
        }
        if (this.rightArm != null) {
            class_630 rightArmPart = baseModel.field_3401;
            RenderUtil.matchModelPartRot((class_630)rightArmPart, (GeoBone)this.rightArm);
            this.rightArm.updatePosition(rightArmPart.field_3657 + 5.0f, 2.0f - rightArmPart.field_3656, rightArmPart.field_3655);
            this.copyScale(rightArmPart, this.rightArm);
        }
        if (this.leftArm != null) {
            class_630 leftArmPart = baseModel.field_27433;
            RenderUtil.matchModelPartRot((class_630)leftArmPart, (GeoBone)this.leftArm);
            this.leftArm.updatePosition(leftArmPart.field_3657 - 5.0f, 2.0f - leftArmPart.field_3656, leftArmPart.field_3655);
            this.copyScale(leftArmPart, this.leftArm);
        }
        if (this.rightLeg != null) {
            class_630 rightLegPart = baseModel.field_3392;
            RenderUtil.matchModelPartRot((class_630)rightLegPart, (GeoBone)this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655 - 0.35f);
            this.copyScale(rightLegPart, this.rightLeg);
        }
        if (this.leftLeg != null) {
            class_630 leftLegPart = baseModel.field_3397;
            RenderUtil.matchModelPartRot((class_630)leftLegPart, (GeoBone)this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655 - 0.7f);
            this.copyScale(leftLegPart, this.leftLeg);
        }
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_742 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_310 mc = class_310.method_1551();
        boolean invisible = entity.method_5767();
        boolean revealed = invisible && !entity.method_5756(ClientUtil.getClientPlayer());
        boolean outlined = mc.method_27022((class_1297)entity);
        if (!invisible || revealed || outlined) {
            class_591 playerEntityModel = (class_591)this.method_17165();
            IPlayerEntityModel accessor = (IPlayerEntityModel)playerEntityModel;
            int argb = Alib.getRenderColor(entity, revealed);
            for (OriginFur fur : ((IPlayerEntity)entity).originsfurs$getCurrentFurs()) {
                OriginFurAnimatable animatable = fur.getAnimatable();
                OriginFurModel model = fur.getGeoModel();
                fur.setRenderColor(argb);
                model.preprocess(accessor, entity);
                fur.setAnimatablePlayer((class_1657)entity);
                this.grabRelevantBones(model);
                this.applyBaseTransformations((class_572<?>)playerEntityModel);
                matrixStack.method_22903();
                class_1921 renderLayer = Alib.getRenderLayer(model.getTextureResource(animatable), !invisible, revealed, outlined, false);
                class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(renderLayer);
                fur.render(matrixStack, animatable, vertexConsumerProvider, renderLayer, vertexConsumer, light, tickDelta);
                matrixStack.method_22909();
            }
        }
    }
}

