/*
 * Decompiled with CFR 0.152.
 */
package com.kio7po.originsfurs.fabric.client.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kio7po.originsfurs.fabric.client.OriginsFursClient;
import com.kio7po.originsfurs.fabric.client.model.OriginFur;
import io.github.apace100.origins.origin.Origin;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;

@Environment(value=EnvType.CLIENT)
public class OriginFurRegistry {
    private static final LinkedHashMap<class_2960, OriginFur> REGISTRY = new LinkedHashMap();
    private static final LinkedHashMap<class_2960, class_3298> RESOURCES = new LinkedHashMap();

    public static void registerFur(class_2960 originId, OriginFur originFur) {
        REGISTRY.put(originId, originFur);
    }

    public static boolean containsFur(class_2960 originId) {
        return REGISTRY.containsKey(originId);
    }

    public static OriginFur getFur(class_2960 originId) {
        return REGISTRY.get(originId);
    }

    public static Set<class_2960> getOriginsIds() {
        return REGISTRY.keySet();
    }

    public static void registerResource(class_2960 originId, class_3298 resource) {
        RESOURCES.put(originId, resource);
    }

    public static class_3298 getResource(class_2960 originId) {
        return RESOURCES.get(originId);
    }

    public static boolean containsResource(class_2960 originId) {
        return RESOURCES.containsKey(originId);
    }

    public static void clear() {
        REGISTRY.clear();
        RESOURCES.clear();
    }

    public static void loadFursFromOrigins(Map<class_2960, Origin> origins) {
        origins.forEach((originId, origin) -> {
            if (!OriginFurRegistry.containsResource(originId)) {
                OriginsFursClient.LOGGER.info("[Origins Furs] Reloading Empty Fur: " + String.valueOf(originId));
                OriginFurRegistry.registerFur(originId, OriginFur.EMPTY);
            } else {
                class_3298 furJson = OriginFurRegistry.getResource(originId);
                try (InputStream inputStream = furJson.method_14482();){
                    OriginsFursClient.LOGGER.info("[Origins Furs] Reloading Fur: " + String.valueOf(originId));
                    String jsonContent = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    JsonObject json = JsonParser.parseString((String)jsonContent).getAsJsonObject();
                    OriginFurRegistry.registerFur(originId, new OriginFur((Origin)origin, json));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void loadFursFromOrigins(Set<Map.Entry<class_2960, Origin>> entrySet) {
        Map<class_2960, Origin> origins = entrySet.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        OriginFurRegistry.loadFursFromOrigins(origins);
    }
}

