/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.action.ModEntityActionTypes;
import dev.muon.medievalorigins.entity.SummonTracker;
import dev.muon.medievalorigins.entity.SummonedMob;
import io.github.apace100.apoli.action.ActionConfiguration;
import io.github.apace100.apoli.action.BiEntityAction;
import io.github.apace100.apoli.action.EntityAction;
import io.github.apace100.apoli.action.context.EntityActionContext;
import io.github.apace100.apoli.action.type.EntityActionType;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;

public class SummonEntityActionType
extends EntityActionType {
    private static final int MAX_SUMMONS = 5;
    public static final TypedDataObjectFactory<SummonEntityActionType> DATA_FACTORY = TypedDataObjectFactory.simple((SerializableData)new SerializableData().add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("weapon", SerializableDataTypes.ITEM_STACK, null).add("duration", SerializableDataTypes.INT.optional(), Optional.empty()).add("tag", SerializableDataTypes.NBT_COMPOUND, (Object)new class_2487()).add("entity_action", EntityAction.DATA_TYPE.optional(), Optional.empty()).add("bientity_action", BiEntityAction.DATA_TYPE.optional(), Optional.empty()), data -> new SummonEntityActionType((class_1299)data.get("entity_type"), (class_1799)data.get("weapon"), (Optional)data.get("duration"), (class_2487)data.get("tag"), (Optional)data.get("entity_action"), (Optional)data.get("bientity_action")), (type, data) -> data.instance().set("entity_type", type.entityType).set("weapon", (Object)type.weapon).set("duration", type.duration).set("tag", (Object)type.entityNbt).set("entity_action", type.entityAction).set("bientity_action", type.biEntityAction));
    private final class_1299<?> entityType;
    private final class_1799 weapon;
    private final Optional<Integer> duration;
    private final class_2487 entityNbt;
    private final Optional<EntityAction> entityAction;
    private final Optional<BiEntityAction> biEntityAction;

    public SummonEntityActionType(class_1299<?> entityType, class_1799 weapon, Optional<Integer> duration, class_2487 entityNbt, Optional<EntityAction> entityAction, Optional<BiEntityAction> biEntityAction) {
        this.entityType = entityType;
        this.weapon = weapon;
        this.duration = duration;
        this.entityNbt = entityNbt;
        this.entityAction = entityAction;
        this.biEntityAction = biEntityAction;
    }

    public void accept(EntityActionContext context) {
        class_3218 serverWorld;
        class_1297 entity;
        block8: {
            block7: {
                entity = context.entity();
                class_1937 class_19372 = entity.method_37908();
                if (!(class_19372 instanceof class_3218)) break block7;
                serverWorld = (class_3218)class_19372;
                if (entity instanceof class_1309) break block8;
            }
            return;
        }
        class_1309 livingCaster = (class_1309)entity;
        Optional entityToSpawn = MiscUtil.getEntityWithPassengers((class_1937)serverWorld, this.entityType, (class_2487)this.entityNbt, (class_243)entity.method_19538(), (float)entity.method_36454(), (float)entity.method_36455());
        if (entityToSpawn.isEmpty()) {
            return;
        }
        class_1297 actualEntityToSpawn = (class_1297)entityToSpawn.get();
        if (actualEntityToSpawn instanceof class_1308) {
            class_1308 mob = (class_1308)actualEntityToSpawn;
            class_1266 difficulty = serverWorld.method_8404(mob.method_24515());
            mob.method_5943((class_5425)serverWorld, difficulty, class_3730.field_16471, null);
            mob.method_5971();
        }
        if (actualEntityToSpawn instanceof SummonedMob) {
            SummonedMob summon = (SummonedMob)actualEntityToSpawn;
            this.duration.ifPresentOrElse(ticks -> {
                summon.setLifeTicks((int)ticks);
                summon.setIsLimitedLife(true);
            }, () -> summon.setIsLimitedLife(false));
            summon.setOwner(livingCaster);
            summon.setOwnerID(entity.method_5667());
            if (this.weapon != null && !this.weapon.method_7960()) {
                summon.setWeapon(this.weapon);
            }
        }
        serverWorld.method_30736(actualEntityToSpawn);
        this.manageSummonLimit(entity);
        this.entityAction.ifPresent(action -> action.execute(actualEntityToSpawn));
        this.biEntityAction.ifPresent(action -> action.execute(entity, actualEntityToSpawn));
    }

    private void manageSummonLimit(class_1297 owner) {
        Collection<SummonedMob> existingSummons = SummonTracker.getSummonsForOwner(owner.method_5667());
        if (existingSummons.size() >= 5) {
            List summonsList = existingSummons.stream().sorted(this.createSummonComparator()).collect(Collectors.toList());
            SummonedMob toRemove = (SummonedMob)summonsList.get(0);
            class_1308 mobToRemove = toRemove.getSelfAsMob();
            if (owner instanceof class_1657) {
                class_1657 player = (class_1657)owner;
                int x = (int)Math.round(mobToRemove.method_23317());
                int y = (int)Math.round(mobToRemove.method_23318());
                int z = (int)Math.round(mobToRemove.method_23321());
                String dimension = mobToRemove.method_37908().method_27983().method_29177().method_12832();
                class_5250 message = class_2561.method_43471((String)"message.medievalorigins.summon_limit_reached").method_27693(" ").method_10852(mobToRemove.method_5476()).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"message.medievalorigins.summon_location", (Object[])new Object[]{dimension, x, y, z}));
                player.method_7353((class_2561)message, true);
            }
            toRemove.getSelfAsMob().method_5650(class_1297.class_5529.field_26999);
            SummonTracker.untrackSummon(toRemove);
        }
    }

    private Comparator<SummonedMob> createSummonComparator() {
        return (a, b) -> {
            if (a.isLimitedLife() != b.isLimitedLife()) {
                return a.isLimitedLife() ? -1 : 1;
            }
            if (a.isLimitedLife() && b.isLimitedLife()) {
                return Integer.compare(a.getLifeTicks(), b.getLifeTicks());
            }
            return this.compareMobTypes(a.getSelfAsMob(), b.getSelfAsMob());
        };
    }

    private int compareMobTypes(class_1308 a, class_1308 b) {
        int priorityA = this.getMobPriority(a);
        int priorityB = this.getMobPriority(b);
        return Integer.compare(priorityA, priorityB);
    }

    private int getMobPriority(class_1308 mob) {
        String entityId;
        return switch (entityId = mob.method_5864().toString()) {
            case "entity.medievalorigins.summon_wither_skeleton" -> 3;
            case "entity.medievalorigins.summon_skeleton" -> 2;
            case "entity.medievalorigins.summon_zombie" -> 1;
            default -> 0;
        };
    }

    @NotNull
    public ActionConfiguration<?> getConfig() {
        return ModEntityActionTypes.SUMMON_ENTITY;
    }
}

