/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.util;

import java.util.HashMap;
import java.util.Map;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class SpellSchoolUtil {
    private static final Map<String, String> FALLBACK_MAP = new HashMap<String, String>();

    public static SpellSchool getSpellSchoolWithFallback(String schoolName) {
        if (schoolName == null || schoolName.isEmpty()) {
            throw new IllegalArgumentException("School name cannot be null or empty.");
        }
        SpellSchool school = null;
        String originalSchoolNameForError = schoolName;
        String currentSchoolNameToTry = schoolName;
        try {
            school = SpellSchools.getSchool((String)currentSchoolNameToTry);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (school == null) {
            String fallbackKey = schoolName.toLowerCase();
            String fallbackSchoolName = FALLBACK_MAP.get(fallbackKey);
            if (fallbackSchoolName != null) {
                currentSchoolNameToTry = fallbackSchoolName;
                try {
                    school = SpellSchools.getSchool((String)currentSchoolNameToTry);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unknown magic school: \"" + originalSchoolNameForError + "\". Fallback school \"" + currentSchoolNameToTry + "\" also failed to parse: " + e.getMessage(), e);
                }
                if (school == null) {
                    throw new IllegalArgumentException("Unknown magic school: \"" + originalSchoolNameForError + "\". Fallback school \"" + currentSchoolNameToTry + "\" resolved to null.");
                }
            } else {
                throw new IllegalArgumentException("Unknown magic school: \"" + originalSchoolNameForError + "\" (not found or resolved to null, and no fallback defined).");
            }
        }
        return school;
    }

    static {
        FALLBACK_MAP.put("earth", "healing");
        FALLBACK_MAP.put("air", "lightning");
        FALLBACK_MAP.put("water", "frost");
    }
}

