/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client.renderers;

import dev.cammiescorner.icarus.api.client.IcarusAPIClient;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.DiscordsWingsModel;
import dev.cammiescorner.icarus.client.models.FeatheredWingsModel;
import dev.cammiescorner.icarus.client.models.FlandresWingsModel;
import dev.cammiescorner.icarus.client.models.LeatherWingsModel;
import dev.cammiescorner.icarus.client.models.LightWingsModel;
import dev.cammiescorner.icarus.client.models.WingEntityModel;
import dev.cammiescorner.icarus.client.models.ZanzasWingsModel;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.item.WingItem;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class WingsLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private final FeatheredWingsModel<T> featheredWings;
    private final LeatherWingsModel<T> leatherWings;
    private final LightWingsModel<T> lightWings;
    private final FlandresWingsModel<T> flandresWings;
    private final DiscordsWingsModel<T> discordsWings;
    private final ZanzasWingsModel<T> zanzasWings;

    public WingsLayer(class_3883<T, M> context, class_5599 loader) {
        super(context);
        this.featheredWings = new FeatheredWingsModel(loader.method_32072(IcarusModels.FEATHERED));
        this.leatherWings = new LeatherWingsModel(loader.method_32072(IcarusModels.LEATHER));
        this.lightWings = new LightWingsModel(loader.method_32072(IcarusModels.LIGHT));
        this.flandresWings = new FlandresWingsModel(loader.method_32072(IcarusModels.FLANDRE));
        this.discordsWings = new DiscordsWingsModel(loader.method_32072(IcarusModels.DISCORD));
        this.zanzasWings = new ZanzasWingsModel(loader.method_32072(IcarusModels.ZANZA));
    }

    public void render(class_4587 pose, class_4597 bufferSource, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1799 stack = IcarusAPIClient.getWingsForRendering(entity);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof WingItem) {
            WingItem wingItem = (WingItem)class_17922;
            if (IcarusClient.shouldRenderWings(entity)) {
                WingEntityModel wingModel;
                int primaryColor = class_5253.class_5254.method_58144((int)255, (int)wingItem.getPrimaryColor(stack).method_7787());
                int secondaryColor = class_5253.class_5254.method_58144((int)255, (int)wingItem.getSecondaryColor(stack).method_7787());
                switch (wingItem.getWingType()) {
                    case FEATHERED: 
                    case MECHANICAL_FEATHERED: {
                        WingEntityModel wingEntityModel = this.featheredWings;
                        break;
                    }
                    case DRAGON: 
                    case MECHANICAL_LEATHER: {
                        WingEntityModel wingEntityModel = this.leatherWings;
                        break;
                    }
                    case LIGHT: {
                        WingEntityModel wingEntityModel = this.lightWings;
                        break;
                    }
                    case UNIQUE: {
                        WingEntityModel wingEntityModel;
                        if (stack.method_31574((class_1792)IcarusItems.FLANDRES_WINGS.get())) {
                            wingEntityModel = this.flandresWings;
                            break;
                        }
                        if (stack.method_31574((class_1792)IcarusItems.DISCORDS_WINGS.get())) {
                            wingEntityModel = this.discordsWings;
                            break;
                        }
                        if (stack.method_31574((class_1792)IcarusItems.ZANZAS_WINGS.get())) {
                            wingEntityModel = this.zanzasWings;
                            break;
                        }
                        wingEntityModel = null;
                        break;
                    }
                    default: {
                        WingEntityModel wingEntityModel = wingModel = null;
                    }
                }
                if (wingModel == null) {
                    return;
                }
                class_2960 layer1 = wingItem.getWingType().getTextureLayer1(stack);
                class_2960 layer2 = wingItem.getWingType().getTextureLayer2(stack);
                pose.method_22903();
                pose.method_22904(0.0, 0.0, 0.125);
                this.method_17165().method_17081(wingModel);
                wingModel.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                this.renderWings(wingModel, pose, bufferSource, stack, class_1921.method_23580((class_2960)layer2), light, secondaryColor);
                this.renderWings(wingModel, pose, bufferSource, stack, class_1921.method_23580((class_2960)layer1), light, primaryColor);
                pose.method_22909();
            }
        }
    }

    public void renderWings(WingEntityModel<T> model, class_4587 matrices, class_4597 vertexConsumers, @Nullable class_1799 stack, class_1921 renderLayer, int light, int color) {
        class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)renderLayer, (stack != null && stack.method_7958() ? 1 : 0) != 0);
        model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, color);
    }
}

