/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.client.render;

import java.util.List;
import java.util.Optional;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.config.ClientConfig;
import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.resources.ObjectLoader;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import owens.oobjloader.Face;
import owens.oobjloader.FaceVertex;

public class ImmersivePaintingEntityRenderer<T extends ImmersivePaintingEntity>
extends class_897<T> {
    public ImmersivePaintingEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 poses, class_4597 buffer, int light) {
        poses.method_22903();
        poses.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        poses.method_22907(class_7833.field_40714.rotationDegrees(-entity.method_5695(tickDelta)));
        poses.method_22905(0.0625f, 0.0625f, 0.0625f);
        this.renderPainting(poses, buffer, entity);
        poses.method_22909();
        super.method_3936(entity, yaw, tickDelta, poses, buffer, light);
    }

    public class_2960 getTextureLocation(T paintingEntity) {
        class_310 client = class_310.method_1551();
        ClientConfig config = Configs.CLIENT;
        double distance = client.field_1724 == null ? 0.0f : client.field_1724.method_5739(paintingEntity);
        double blocksVisible = Math.tan((double)((Integer)client.field_1690.method_41808().method_41753()).intValue() / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        Optional<Painting> painting = ClientPaintingManager.getPainting(((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive());
        if (painting.isEmpty()) {
            return ClientPaintingManager.getImageIdentifier(Painting.DEFAULT_IDENTIFIER, Painting.Size.FULL);
        }
        int resolution = painting.get().resolution();
        double pixelDensity = blocksVisible * (double)resolution / (double)client.method_22683().method_4506();
        Painting.Size size = pixelDensity > (double)config.thumbResolutionThreshold ? Painting.Size.THUMBNAIL : (pixelDensity > (double)config.eighthResolutionThreshold ? Painting.Size.EIGHTH : (pixelDensity > (double)config.quarterResolutionThreshold ? Painting.Size.QUARTER : (pixelDensity > (double)config.halfResolutionThreshold ? Painting.Size.HALF : Painting.Size.FULL)));
        return ClientPaintingManager.getImageIdentifier(((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive(), size);
    }

    protected int getLight(int light, boolean glowing) {
        if (!glowing) {
            return light;
        }
        return class_765.method_23687((int)((int)((double)class_765.method_24186((int)light) * 0.25 + 11.25)), (int)class_765.method_24187((int)light));
    }

    protected int getFrameLight(int light, boolean glowing) {
        if (!glowing) {
            return light;
        }
        return class_765.method_23687((int)((int)((double)class_765.method_24186((int)light) * 0.875 + 2.0)), (int)class_765.method_24187((int)light));
    }

    private void renderPainting(class_4587 poses, class_4597 buffer, T entity) {
        int light = class_761.method_23794((class_1920)entity.method_37908(), (class_2338)entity.method_24515());
        class_4587.class_4665 pose = poses.method_23760();
        boolean hasFrame = !((ImmersivePaintingEntity)((Object)entity)).getFrame().method_12832().equals("none");
        int widthPixels = ((ImmersivePaintingEntity)((Object)entity)).getPaintingWidth() * 16;
        int heightPixels = ((ImmersivePaintingEntity)((Object)entity)).getPaintingHeight() * 16;
        boolean glowing = ((ImmersivePaintingEntity)((Object)entity)).isGlowing();
        boolean graffiti = ((ImmersivePaintingEntity)((Object)entity)).isGraffiti();
        class_4588 vertexConsumer = buffer.getBuffer(graffiti ? class_1921.method_23580((class_2960)this.getTextureLocation(entity)) : class_1921.method_23572((class_2960)this.getTextureLocation(entity)));
        this.renderFaces(graffiti ? "objects/graffiti.obj" : "objects/canvas.obj", pose, vertexConsumer, this.getLight(light, glowing), widthPixels, heightPixels, hasFrame ? 1.0f : 0.0f);
        if (hasFrame) {
            vertexConsumer = buffer.getBuffer(class_1921.method_23576((class_2960)((ImmersivePaintingEntity)((Object)entity)).getMaterial()));
            this.renderFrame(((ImmersivePaintingEntity)((Object)entity)).getFrame(), pose, vertexConsumer, this.getFrameLight(light, glowing), widthPixels, heightPixels);
        }
    }

    private void renderFaces(String name, class_4587.class_4665 pose, class_4588 vertexConsumer, int light, float width, float height, float margin) {
        List<Face> faces = ObjectLoader.objects.get(Main.locate(name));
        for (Face face : faces) {
            for (FaceVertex v : face.vertices) {
                this.vertex(pose, vertexConsumer, v.v.x * (width - margin * 2.0f), v.v.y * (height - margin * 2.0f), v.v.z * 16.0f, v.t.u * (width - margin * 2.0f) / width + margin / width, (1.0f - v.t.v) * (height - margin * 2.0f) / height + margin / height, v.n.x, v.n.y, v.n.z, light);
            }
        }
    }

    private List<Face> getFaces(class_2960 frame, String part) {
        class_2960 id = class_2960.method_60655((String)frame.method_12836(), (String)(frame.method_12832() + "/" + part + ".obj"));
        if (ObjectLoader.objects.containsKey(id)) {
            return ObjectLoader.objects.get(id);
        }
        return List.of();
    }

    private void renderFrame(class_2960 frame, class_4587.class_4665 pose, class_4588 vertexConsumer, int light, float width, float height) {
        float u;
        List<Face> faces = this.getFaces(frame, "bottom");
        int x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "top");
        x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y + (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "right");
        int y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x + (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
        faces = this.getFaces(frame, "left");
        y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x - (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
    }

    private void vertex(class_4587.class_4665 pose, class_4588 vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light) {
        vertexConsumer.method_56824(pose, x, y, z - 0.5f).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, normalX, normalY, normalZ);
    }
}

