/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.dev;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.util.ImageManipulations;

public class DatapackPaintingsGenerator {
    static final String base = "../paintings/";
    static final String output = "../common/src/main/resources/data/immersive_paintings/paintings/";

    public static void run() throws IOException {
        try {
            Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            Main.LOGGER.error("failed creating output directory {}", (Object)output, (Object)e);
        }
        for (int res : new int[]{16, 32, 64, 128}) {
            DatapackPaintingsGenerator.process("Airships - AlexRuizArt.jpg", 5, 3, 0.25, 0, res, false);
            DatapackPaintingsGenerator.process("Autumn - NostalgiaTree.png", 3, 2, 0.0, 0, res, false);
            DatapackPaintingsGenerator.process("Beyond Hill and Dale - Alena Aenami.jpg", 2, 1, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Calm Days by the Lake - Scilex.png", 2, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Cavern - sennin13.png", 2, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("concept - BINU BALAN.jpg", 4, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Cthulhu - Andree Wallin.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Dark Phoenix - Starkiteckt.png", 4, 2, 0.0, 32, res, false);
            DatapackPaintingsGenerator.process("Frost Valley - Jorge Jacinto.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Hazy Castle - David Frasheski.jpg", 5, 2, 0.0, 12, res, false);
            DatapackPaintingsGenerator.process("Ikran Nebula - Starkiteckt.png", 2, 1, 0.0, 32, res, false);
            DatapackPaintingsGenerator.process("Lake - Sarel Theron.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Life In The Sky - Vladimir Kostuchek.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Nevermore - Josef Barton.jpg", 3, 2, 0.25, 15, res, false);
            DatapackPaintingsGenerator.process("Small Memory - Mikael Gustafsson.jpg", 3, 2, 0.0, 12, res, false);
            DatapackPaintingsGenerator.process("The Ancient Ones - Jessica Woulfe.jpg", 2, 1, 0.5, 12, res, false);
            DatapackPaintingsGenerator.process("The Esteemed Palace - Chris Ostrowski.png", 2, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("The Lost Legend - Xu Tianhua.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("The Torch - Starkiteckt.png", 3, 3, 0.0, 32, res, false);
            DatapackPaintingsGenerator.process("Tranquil Sunday Walk - Scilex.png", 4, 4, 0.0, 0, res, true);
            DatapackPaintingsGenerator.process("Windmill Town - Darek Zabrocki.jpg", 5, 3, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Gothic Landscape - Soroka Alexej.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Gothic Landscape - Soroka Alexej.jpg", 3, 2, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Deer Landscape - Byzwa Dher.jpg", 2, 1, 0.25, 12, res, false);
            DatapackPaintingsGenerator.process("Venedig - Verena.jpg", 1, 1, 0.25, 12, res, false);
        }
        DatapackPaintingsGenerator.process("Underwater - tox5000.png", 4, 4, 0.0, 0, 32, true);
        System.exit(0);
    }

    private static void process(String name, int width, int height, double dither, int colors, int resolution, boolean pixelArt) throws IOException {
        BufferedImage image = DatapackPaintingsGenerator.loadImage((String)name);
        int zoom = ImageManipulations.scanForPixelArtMultiple(image);
        if (image.getWidth() / zoom < width * resolution || image.getHeight() / zoom < height * resolution) {
            return;
        }
        String[] split = ((String)name).replace(".png", "").replace(".jpg", "").split(" - ");
        name = output + ((String)name).toLowerCase(Locale.ROOT).replace(" ", "").replace(".png", "").replace(".jpg", "") + "-" + resolution + "px";
        FileWriter writer = new FileWriter((String)name + ".json");
        writer.write(String.format("{\n\t\"name\": \"%s\",\n\t\"author\": \"%s\",\n\t\"resolution\": %d,\n\t\"width\": %d,\n\t\"height\": %d\n}", split[0], split[1], resolution, width, height));
        writer.close();
        ImmersivePaintingScreen.PixelatorSettings settings = new ImmersivePaintingScreen.PixelatorSettings(dither / 2.0, colors, resolution, width, height, 0.5, 0.5, 1.0, pixelArt);
        File file = new File((String)name + ".png");
        try {
            ImageIO.write((RenderedImage)ImmersivePaintingScreen.pixelateImage(image, settings), "png", file);
        }
        catch (IOException e) {
            Main.LOGGER.error("could not load datapack image {}", name, (Object)e);
        }
    }

    private static BufferedImage loadImage(String path) throws IOException {
        FileInputStream stream = new FileInputStream(Path.of(base, path).toFile());
        BufferedImage image = ImageIO.read(stream);
        stream.close();
        return image;
    }
}

