/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation.dispatch.command.action.registry;

import it.unimi.dsi.fastutil.objects.Object2ShortArrayMap;
import java.util.HashMap;
import java.util.Map;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.AzAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerCancelAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerPlayAnimationSequenceAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetAnimationSpeedAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetEasingTypeAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetFreezeTickAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetRepeatTimesAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetReverseAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetStartTickOffsetAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.controller.AzControllerSetTransitionSpeedAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootCancelAllAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootPlayAnimationSequenceAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetAnimationSpeedAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetEasingTypeAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetFreezeTickAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetRepeatTimesAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetReverseAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetStartTickOffsetAction;
import mod.azure.azurelibarmor.common.animation.dispatch.command.action.impl.root.AzRootSetTransitionSpeedAction;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class AzActionRegistry {
    private static final Map<class_2960, Short> RESOURCE_LOCATION_TO_ID = new Object2ShortArrayMap();
    private static final Map<Short, class_9139<class_2540, ? extends AzAction>> CODEC_BY_ID = new HashMap<Short, class_9139<class_2540, ? extends AzAction>>();
    private static short NEXT_FREE_ID = 0;

    private AzActionRegistry() {
    }

    @Nullable
    public static <A, T extends class_9139<class_2540, A>> T getCodecOrNull(class_2960 resourceLocation) {
        Short id = RESOURCE_LOCATION_TO_ID.get(resourceLocation);
        class_9139<class_2540, ? extends AzAction> codec = CODEC_BY_ID.get(id);
        return (T)codec;
    }

    @Nullable
    public static <A, T extends class_9139<class_2540, A>> T getCodecOrNull(short id) {
        class_9139<class_2540, ? extends AzAction> codec = CODEC_BY_ID.get(id);
        return (T)codec;
    }

    @Nullable
    public static Short getIdOrNull(class_2960 resourceLocation) {
        return RESOURCE_LOCATION_TO_ID.get(resourceLocation);
    }

    private static <A extends AzAction> void register(class_2960 resourceLocation, class_9139<class_2540, A> codec) {
        Short id = RESOURCE_LOCATION_TO_ID.computeIfAbsent(resourceLocation, $ -> {
            short s = NEXT_FREE_ID;
            NEXT_FREE_ID = (short)(s + 1);
            return s;
        });
        CODEC_BY_ID.put(id, codec);
    }

    static {
        AzActionRegistry.register(AzRootCancelAllAction.RESOURCE_LOCATION, AzRootCancelAllAction.CODEC);
        AzActionRegistry.register(AzRootPlayAnimationSequenceAction.RESOURCE_LOCATION, AzRootPlayAnimationSequenceAction.CODEC);
        AzActionRegistry.register(AzRootSetAnimationSpeedAction.RESOURCE_LOCATION, AzRootSetAnimationSpeedAction.CODEC);
        AzActionRegistry.register(AzRootSetEasingTypeAction.RESOURCE_LOCATION, AzRootSetEasingTypeAction.CODEC);
        AzActionRegistry.register(AzRootSetTransitionSpeedAction.RESOURCE_LOCATION, AzRootSetTransitionSpeedAction.CODEC);
        AzActionRegistry.register(AzRootSetStartTickOffsetAction.RESOURCE_LOCATION, AzRootSetStartTickOffsetAction.CODEC);
        AzActionRegistry.register(AzRootSetFreezeTickAction.RESOURCE_LOCATION, AzRootSetFreezeTickAction.CODEC);
        AzActionRegistry.register(AzRootSetRepeatTimesAction.RESOURCE_LOCATION, AzRootSetRepeatTimesAction.CODEC);
        AzActionRegistry.register(AzRootSetReverseAction.RESOURCE_LOCATION, AzRootSetReverseAction.CODEC);
        AzActionRegistry.register(AzControllerCancelAction.RESOURCE_LOCATION, AzControllerCancelAction.CODEC);
        AzActionRegistry.register(AzControllerPlayAnimationSequenceAction.RESOURCE_LOCATION, AzControllerPlayAnimationSequenceAction.CODEC);
        AzActionRegistry.register(AzControllerSetAnimationSpeedAction.RESOURCE_LOCATION, AzControllerSetAnimationSpeedAction.CODEC);
        AzActionRegistry.register(AzControllerSetEasingTypeAction.RESOURCE_LOCATION, AzControllerSetEasingTypeAction.CODEC);
        AzActionRegistry.register(AzControllerSetTransitionSpeedAction.RESOURCE_LOCATION, AzControllerSetTransitionSpeedAction.CODEC);
        AzActionRegistry.register(AzControllerSetStartTickOffsetAction.RESOURCE_LOCATION, AzControllerSetStartTickOffsetAction.CODEC);
        AzActionRegistry.register(AzControllerSetFreezeTickAction.RESOURCE_LOCATION, AzControllerSetFreezeTickAction.CODEC);
        AzActionRegistry.register(AzControllerSetRepeatTimesAction.RESOURCE_LOCATION, AzControllerSetRepeatTimesAction.CODEC);
        AzActionRegistry.register(AzControllerSetReverseAction.RESOURCE_LOCATION, AzControllerSetReverseAction.CODEC);
    }
}

