/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation.property.codec;

import mod.azure.azurelibarmor.common.animation.easing.AzEasingType;
import mod.azure.azurelibarmor.common.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelibarmor.common.animation.easing.AzEasingTypes;
import mod.azure.azurelibarmor.common.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelibarmor.common.animation.play_behavior.AzPlayBehaviorRegistry;
import mod.azure.azurelibarmor.common.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelibarmor.common.animation.property.AzAnimationStageProperties;
import net.minecraft.class_2540;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class AzAnimationStagePropertiesCodec
implements class_9139<class_2540, AzAnimationStageProperties> {
    @NotNull
    public AzAnimationStageProperties decode(class_2540 buf) {
        int propertyLength = buf.readByte();
        AzAnimationStageProperties properties = AzAnimationStageProperties.EMPTY;
        block10: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    properties = properties.withAnimationSpeed(buf.readDouble());
                    continue block10;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block10;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.method_19772(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                    continue block10;
                }
                case 3: {
                    AzPlayBehavior playBehavior = AzPlayBehaviorRegistry.getOrDefault(buf.method_19772(), AzPlayBehaviors.PLAY_ONCE);
                    properties = properties.withPlayBehavior(playBehavior);
                    continue block10;
                }
                case 4: {
                    properties = properties.withStartTickOffset(buf.readFloat());
                    continue block10;
                }
                case 5: {
                    properties = properties.withFreezeTickOffset(buf.readDouble());
                    continue block10;
                }
                case 6: {
                    properties = properties.withRepeatXTimes(buf.readDouble());
                    continue block10;
                }
                case 7: {
                    properties = properties.withShouldReverse(buf.readBoolean());
                }
            }
        }
        return properties;
    }

    public void encode(class_2540 buf, AzAnimationStageProperties properties) {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        propertyLength += properties.hasEasingType() ? 1 : 0;
        propertyLength += properties.hasPlayBehavior() ? 1 : 0;
        propertyLength += properties.hasStartTickOffset() ? 1 : 0;
        propertyLength += properties.hasFreezeTickOffset() ? 1 : 0;
        propertyLength += properties.hasRepeatXTimes() ? 1 : 0;
        buf.method_52997(propertyLength += properties.hasReversing() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.method_52997(0);
            buf.method_52940(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.method_52997(1);
            buf.method_52941(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.method_52997(2);
            buf.method_10814(properties.easingType().name());
        }
        if (properties.hasPlayBehavior()) {
            buf.method_52997(3);
            buf.method_10814(properties.playBehavior().name());
        }
        if (properties.hasStartTickOffset()) {
            buf.method_52997(4);
            buf.method_52940(properties.startTickOffset());
        }
        if (properties.hasFreezeTickOffset()) {
            buf.method_52997(5);
            buf.method_52940(properties.freezeTickOffset());
        }
        if (properties.hasRepeatXTimes()) {
            buf.method_52997(6);
            buf.method_52940(properties.repeatXTimes());
        }
        if (properties.hasReversing()) {
            buf.method_52997(7);
            buf.method_52964(properties.isReversing());
        }
    }
}

