/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.model.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.common.cache.AzResourceCache;
import mod.azure.azurelibarmor.common.loading.FileLoader;
import mod.azure.azurelibarmor.common.loading.json.raw.Model;
import mod.azure.azurelibarmor.common.loading.object.GeometryTree;
import mod.azure.azurelibarmor.common.model.AzBakedModel;
import mod.azure.azurelibarmor.common.model.factory.registry.AzBakedModelFactoryRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class AzBakedModelCache
extends AzResourceCache {
    private static final AzBakedModelCache INSTANCE = new AzBakedModelCache();
    private final Map<class_2960, AzBakedModel> bakedModels = new Object2ObjectOpenHashMap();

    public static AzBakedModelCache getInstance() {
        return INSTANCE;
    }

    private AzBakedModelCache() {
    }

    public CompletableFuture<Void> loadModels(Executor backgroundExecutor, class_3300 resourceManager) {
        return this.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            Model model = FileLoader.loadModelFile(resource, resourceManager);
            if (model == null) {
                class_2960 defaultModelLocation = AzureLib.modResource("geo/default_model.geo.json");
                model = FileLoader.loadModelFile(defaultModelLocation, resourceManager);
                AzBakedModel defaultBaked = AzBakedModelFactoryRegistry.getForNamespace(resource.method_12836()).constructGeoModel(GeometryTree.fromModel(model));
                AzBakedModel.setDefault(defaultBaked);
            }
            return AzBakedModelFactoryRegistry.getForNamespace(resource.method_12836()).constructGeoModel(GeometryTree.fromModel(model));
        }, this.bakedModels::put);
    }

    @Nullable
    public AzBakedModel getNullable(class_2960 resourceLocation) {
        return this.bakedModels.get(resourceLocation);
    }
}

