/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render;

import java.util.Collection;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.model.AzBone;
import mod.azure.azurelibarmor.common.render.AzRendererPipelineContext;
import mod.azure.azurelibarmor.common.render.layer.AzRenderLayer;

public class AzLayerRenderer<K, T> {
    private final Supplier<Collection<AzRenderLayer<K, T>>> renderLayerSupplier;

    public AzLayerRenderer(Supplier<Collection<AzRenderLayer<K, T>>> renderLayerSupplier) {
        this.renderLayerSupplier = renderLayerSupplier;
    }

    protected void preApplyRenderLayers(AzRendererPipelineContext<K, T> context) {
        for (AzRenderLayer<K, T> renderLayer : this.renderLayerSupplier.get()) {
            renderLayer.preRender(context);
        }
    }

    public void applyRenderLayersForBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
        for (AzRenderLayer<K, T> renderLayer : this.renderLayerSupplier.get()) {
            renderLayer.renderForBone(context, bone);
        }
    }

    protected void applyRenderLayers(AzRendererPipelineContext<K, T> context) {
        for (AzRenderLayer<K, T> renderLayer : this.renderLayerSupplier.get()) {
            renderLayer.render(context);
        }
    }
}

