/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.animation.AzAnimator;
import mod.azure.azurelibarmor.common.model.AzBone;
import mod.azure.azurelibarmor.common.render.AzLayerRenderer;
import mod.azure.azurelibarmor.common.render.AzModelRenderer;
import mod.azure.azurelibarmor.common.render.AzRendererPipeline;
import mod.azure.azurelibarmor.common.render.AzRendererPipelineContext;
import mod.azure.azurelibarmor.common.render.layer.AzRenderLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzRendererConfig<K, T> {
    private final Supplier<@Nullable AzAnimator<K, T>> animatorProvider;
    private final BiFunction<@Nullable class_1297, T, class_2960> modelLocationProvider;
    private final BiFunction<AzRendererPipeline<K, T>, AzLayerRenderer<K, T>, AzModelRenderer<K, T>> modelRendererProvider;
    private final Function<AzRendererPipeline<K, T>, AzRendererPipelineContext<K, T>> pipelineContextFunction;
    private final BiFunction<@Nullable class_1297, T, class_1921> renderTypeFunction;
    private final Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> preRenderEntry;
    private final Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> renderEntry;
    private final Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> postRenderEntry;
    private final List<AzRenderLayer<K, T>> renderLayers;
    private final BiFunction<@Nullable class_1297, T, class_2960> textureLocationProvider;
    private final Function<T, Float> alphaFunction;
    private final Function<T, Float> scaleHeight;
    private final Function<T, Float> scaleWidth;
    @Nullable
    private final Function<AzBone, class_2960> boneTextureOverrideProvider;
    @Nullable
    private final Function<AzBone, class_1921> boneRenderTypeOverrideProvider;

    public AzRendererConfig(Supplier<AzAnimator<K, T>> animatorProvider, BiFunction<@Nullable class_1297, T, class_2960> modelLocationProvider, BiFunction<AzRendererPipeline<K, T>, AzLayerRenderer<K, T>, AzModelRenderer<K, T>> modelRendererProvider, Function<AzRendererPipeline<K, T>, AzRendererPipelineContext<K, T>> pipelineContextFunction, BiFunction<@Nullable class_1297, T, class_1921> renderTypeFunction, List<AzRenderLayer<K, T>> renderLayers, Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> preRenderEntry, Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> renderEntry, Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> postRenderEntry, BiFunction<@Nullable class_1297, T, class_2960> textureLocationProvider, Function<T, Float> alphaFunction, Function<T, Float> scaleHeight, Function<T, Float> scaleWidth, Function<AzBone, class_2960> boneTextureOverrideProvider, Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
        this.animatorProvider = animatorProvider;
        this.modelLocationProvider = modelLocationProvider;
        this.modelRendererProvider = modelRendererProvider;
        this.pipelineContextFunction = pipelineContextFunction;
        this.renderTypeFunction = renderTypeFunction;
        this.renderLayers = Collections.unmodifiableList(renderLayers);
        this.preRenderEntry = preRenderEntry;
        this.renderEntry = renderEntry;
        this.postRenderEntry = postRenderEntry;
        this.textureLocationProvider = textureLocationProvider;
        this.alphaFunction = alphaFunction;
        this.scaleHeight = scaleHeight;
        this.scaleWidth = scaleWidth;
        this.boneTextureOverrideProvider = boneTextureOverrideProvider;
        this.boneRenderTypeOverrideProvider = boneRenderTypeOverrideProvider;
    }

    @Nullable
    public AzAnimator<K, T> createAnimator() {
        return this.animatorProvider.get();
    }

    public class_2960 modelLocation(T animatable) {
        return this.modelLocation(null, animatable);
    }

    public class_2960 modelLocation(@Nullable class_1297 entity, T animatable) {
        return this.modelLocationProvider.apply(entity, (class_1297)animatable);
    }

    public AzRendererPipelineContext<K, T> pipelineContext(AzRendererPipeline<K, T> pipeline) {
        return this.pipelineContextFunction.apply(pipeline);
    }

    public class_2960 textureLocation(T animatable) {
        return this.textureLocation(null, animatable);
    }

    public class_2960 textureLocation(@Nullable class_1297 entity, T animatable) {
        return this.textureLocationProvider.apply(entity, (class_1297)animatable);
    }

    public AzModelRenderer<K, T> modelRendererProvider(AzRendererPipeline<K, T> pipeline, AzLayerRenderer<K, T> layerRenderer) {
        return this.modelRendererProvider.apply(pipeline, layerRenderer);
    }

    public class_1921 getRenderType(T animatable) {
        return this.getRenderType(null, animatable);
    }

    public class_1921 getRenderType(@Nullable class_1297 entity, T animatable) {
        return this.renderTypeFunction.apply(entity, (class_1297)animatable);
    }

    public List<AzRenderLayer<K, T>> renderLayers() {
        return this.renderLayers;
    }

    public AzRendererPipelineContext<K, T> preRenderEntry(AzRendererPipelineContext<K, T> animatable) {
        return this.preRenderEntry.apply(animatable);
    }

    public AzRendererPipelineContext<K, T> renderEntry(AzRendererPipelineContext<K, T> animatable) {
        return this.renderEntry.apply(animatable);
    }

    public AzRendererPipelineContext<K, T> postRenderEntry(AzRendererPipelineContext<K, T> animatable) {
        return this.postRenderEntry.apply(animatable);
    }

    public float alpha(T entity) {
        return this.alphaFunction.apply(entity).floatValue();
    }

    public float scaleHeight(T entity) {
        return this.scaleHeight.apply(entity).floatValue();
    }

    public float scaleWidth(T entity) {
        return this.scaleWidth.apply(entity).floatValue();
    }

    @Nullable
    public class_2960 boneTextureOverrideProvider(AzBone bone) {
        return this.boneTextureOverrideProvider.apply(bone);
    }

    @Nullable
    public class_1921 boneRenderTypeOverrideProvider(AzBone bone) {
        return this.boneRenderTypeOverrideProvider.apply(bone);
    }

    public static class Builder<K, T> {
        protected final BiFunction<@Nullable class_1297, T, class_2960> modelLocationProvider;
        protected BiFunction<AzRendererPipeline<K, T>, AzLayerRenderer<K, T>, AzModelRenderer<K, T>> modelRendererProvider;
        protected Function<AzRendererPipeline<K, T>, AzRendererPipelineContext<K, T>> pipelineContextFunction;
        protected BiFunction<@Nullable class_1297, T, class_1921> renderTypeProvider;
        public final List<AzRenderLayer<K, T>> renderLayers;
        protected Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> preRenderEntry;
        protected Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> renderEntry;
        protected Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> postRenderEntry;
        protected final BiFunction<@Nullable class_1297, T, class_2960> textureLocationProvider;
        protected Supplier<@Nullable AzAnimator<K, T>> animatorProvider = () -> null;
        protected Function<T, Float> alphaFunction;
        protected Function<T, Float> scaleHeight;
        protected Function<T, Float> scaleWidth;
        @Nullable
        private Function<AzBone, class_2960> boneTextureOverrideProvider;
        @Nullable
        private Function<AzBone, class_1921> boneRenderTypeOverrideProvider;

        protected Builder(BiFunction<@Nullable class_1297, T, class_2960> modelLocationProvider, BiFunction<@Nullable class_1297, T, class_2960> textureLocationProvider) {
            this.modelLocationProvider = modelLocationProvider;
            this.modelRendererProvider = AzModelRenderer::new;
            this.pipelineContextFunction = null;
            this.renderTypeProvider = (a, b) -> class_1921.method_23576((class_2960)((class_2960)textureLocationProvider.apply((class_1297)a, (class_1297)b)));
            this.renderLayers = new ObjectArrayList();
            this.preRenderEntry = $ -> $;
            this.renderEntry = $ -> $;
            this.postRenderEntry = $ -> $;
            this.textureLocationProvider = textureLocationProvider;
            this.alphaFunction = $ -> Float.valueOf(1.0f);
            this.scaleHeight = $ -> Float.valueOf(1.0f);
            this.scaleWidth = $ -> Float.valueOf(1.0f);
            this.boneTextureOverrideProvider = $ -> null;
            this.boneRenderTypeOverrideProvider = $ -> null;
        }

        public Builder<K, T> setBoneTextureOverrideProvider(Function<AzBone, class_2960> boneTextureOverrideProvider) {
            this.boneTextureOverrideProvider = boneTextureOverrideProvider;
            return this;
        }

        public Builder<K, T> setBoneRenderTypeOverrideProvider(Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
            this.boneRenderTypeOverrideProvider = boneRenderTypeOverrideProvider;
            return this;
        }

        public Builder<K, T> setModelRenderer(BiFunction<AzRendererPipeline<K, T>, AzLayerRenderer<K, T>, AzModelRenderer<K, T>> modelRendererProvider) {
            this.modelRendererProvider = modelRendererProvider;
            return this;
        }

        public Builder<K, T> setPipelineContext(Function<AzRendererPipeline<K, T>, AzRendererPipelineContext<K, T>> pipelineContextFunction) {
            this.pipelineContextFunction = pipelineContextFunction;
            return this;
        }

        public Builder<K, T> setPrerenderEntry(Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> preRenderEntry) {
            this.preRenderEntry = preRenderEntry;
            return this;
        }

        public Builder<K, T> setRenderEntry(Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> renderEntry) {
            this.renderEntry = renderEntry;
            return this;
        }

        public Builder<K, T> setPostRenderEntry(Function<AzRendererPipelineContext<K, T>, AzRendererPipelineContext<K, T>> postRenderEntry) {
            this.postRenderEntry = postRenderEntry;
            return this;
        }

        public Builder<K, T> setAnimatorProvider(Supplier<@Nullable AzAnimator<K, T>> animatorProvider) {
            this.animatorProvider = animatorProvider;
            return this;
        }

        public Builder<K, T> addRenderLayer(AzRenderLayer<K, T> renderLayer) {
            this.renderLayers.add(renderLayer);
            return this;
        }

        public Builder<K, T> setAlpha(Function<T, Float> alphaFunction) {
            this.alphaFunction = alphaFunction;
            return this;
        }

        public Builder<K, T> setAlpha(float alpha) {
            this.alphaFunction = $ -> Float.valueOf(alpha);
            return this;
        }

        public Builder<K, T> setScale(float scale) {
            return this.setScale(scale, scale);
        }

        public Builder<K, T> setScale(float scaleWidth, float scaleHeight) {
            this.scaleHeight = $ -> Float.valueOf(scaleHeight);
            this.scaleWidth = $ -> Float.valueOf(scaleWidth);
            return this;
        }

        public Builder<K, T> setScale(Function<T, Float> scaleFunction) {
            this.scaleHeight = scaleFunction;
            this.scaleWidth = scaleFunction;
            return this;
        }

        public Builder<K, T> setScale(Function<T, Float> scaleHeightFunction, Function<T, Float> scaleWidthFunction) {
            this.scaleHeight = scaleHeightFunction;
            this.scaleWidth = scaleWidthFunction;
            return this;
        }

        public AzRendererConfig<K, T> build() {
            return new AzRendererConfig<K, T>(this.animatorProvider, this.modelLocationProvider, this.modelRendererProvider, this.pipelineContextFunction, this.renderTypeProvider, this.renderLayers, this.preRenderEntry, this.renderEntry, this.postRenderEntry, this.textureLocationProvider, this.alphaFunction, this.scaleHeight, this.scaleWidth, this.boneTextureOverrideProvider, this.boneRenderTypeOverrideProvider);
        }
    }
}

