/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.client;

import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.client.ConfigScreenFactoryRegistry;
import fuzs.forgeconfigapiport.fabric.impl.client.commands.FabricConfigCommand;
import fuzs.forgeconfigapiport.fabric.impl.network.ConfigSync;
import fuzs.forgeconfigapiport.fabric.impl.network.payload.ConfigFilePayload;
import fuzs.forgeconfigapiport.impl.services.CommonAbstractions;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ForgeConfigAPIPortFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ForgeConfigAPIPortFabricClient.registerMessages();
        ForgeConfigAPIPortFabricClient.registerEventHandlers();
        ForgeConfigAPIPortFabricClient.setupDevelopmentEnvironment();
    }

    private static void registerMessages() {
        ClientConfigurationNetworking.registerGlobalReceiver(ConfigFilePayload.TYPE, (payload, context) -> ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName()));
    }

    private static void registerEventHandlers() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> FabricConfigCommand.register(dispatcher, FabricClientCommandSource::sendFeedback));
        ClientConfigurationConnectionEvents.COMPLETE.register((handler, client) -> ConfigSync.handleClientLoginSuccess());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ModConfigs.getFileMap().values().forEach(config -> {
            IConfigSpec patt0$temp = config.getSpec();
            if (patt0$temp instanceof ModConfigSpec) {
                ModConfigSpec spec = (ModConfigSpec)patt0$temp;
                spec.resetCaches(ModConfigSpec.RestartType.WORLD);
            }
        }));
    }

    private static void setupDevelopmentEnvironment() {
        if (CommonAbstractions.INSTANCE.includeTestConfigs()) {
            ConfigScreenFactoryRegistry.INSTANCE.register("forgeconfigapiport", ConfigurationScreen::new);
        }
    }
}

