/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingBoardRecipe
implements class_1860<CuttingBoardRecipeInput> {
    public static final int MAX_RESULTS = 4;
    private final String group;
    private final class_1856 input;
    private final class_1856 tool;
    private final class_2371<ChanceResult> results;
    private final Optional<class_3414> soundEvent;

    public CuttingBoardRecipe(String group, class_1856 input, class_1856 tool, class_2371<ChanceResult> results, Optional<class_3414> soundEvent) {
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    public boolean matches(CuttingBoardRecipeInput input, class_1937 level) {
        return this.input.method_8093(input.item()) && this.tool.method_8093(input.tool());
    }

    public class_1799 assemble(CuttingBoardRecipeInput inv, class_7225.class_7874 provider) {
        return ((ChanceResult)this.results.get(0)).stack().method_7972();
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 nonnulllist = class_2371.method_10211();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return ((ChanceResult)this.results.get(0)).stack();
    }

    public List<class_1799> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public class_2371<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<class_1799> rollResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        class_2371<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            class_1799 stack = output.rollOutput(rand, fortuneLevel);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public Optional<class_3414> getSoundEvent() {
        return this.soundEvent;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.getMaxInputCount();
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.CUTTING.get();
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.CUTTING.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CuttingBoardRecipe that = (CuttingBoardRecipe)o;
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (!this.input.equals((Object)that.input)) {
            return false;
        }
        if (!this.getTool().equals((Object)that.getTool())) {
            return false;
        }
        if (!this.getResults().equals(that.getResults())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.method_8112() != null ? this.method_8112().hashCode() : 0;
        result = 31 * result + this.input.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResults().hashCode();
        result = 31 * result + this.soundEvent.map(Object::hashCode).orElse(0);
        return result;
    }

    public static class Serializer
    implements class_1865<CuttingBoardRecipe> {
        public static final class_9139<class_9129, CuttingBoardRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<CuttingBoardRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(CuttingBoardRecipe::method_8112), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            if (ingredients.isEmpty()) {
                return DataResult.error(() -> "No ingredients for cutting recipe");
            }
            if (ingredients.size() > 1) {
                return DataResult.error(() -> "Too many ingredients for cutting recipe! Please define only one ingredient");
            }
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.add((Object)((class_1856)ingredients.get(0)));
            return DataResult.success((Object)((class_1856)ingredients.get(0)));
        }, ingredient -> {
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.add(ingredient);
            return DataResult.success((Object)nonNullList);
        }).forGetter(cuttingBoardRecipe -> cuttingBoardRecipe.input), (App)class_1856.field_46095.fieldOf("tool").forGetter(CuttingBoardRecipe::getTool), (App)Codec.list(ChanceResult.CODEC).fieldOf("result").flatXmap(chanceResults -> {
            if (chanceResults.size() > 4) {
                return DataResult.error(() -> "Too many results for cutting recipe! The maximum quantity of unique results is 4");
            }
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(CuttingBoardRecipe::getRollableResults), (App)class_3414.field_41698.optionalFieldOf("sound").forGetter(CuttingBoardRecipe::getSoundEvent)).apply((Applicative)inst, CuttingBoardRecipe::new));

        public static CuttingBoardRecipe fromNetwork(class_9129 buffer) {
            Optional holder;
            String groupIn = buffer.method_10800(Short.MAX_VALUE);
            class_1856 inputItemIn = (class_1856)class_1856.field_48355.decode((Object)buffer);
            class_1856 toolIn = (class_1856)class_1856.field_48355.decode((Object)buffer);
            int i = buffer.method_10816();
            class_2371 resultsIn = class_2371.method_10213((int)i, (Object)ChanceResult.EMPTY);
            resultsIn.replaceAll(ignored -> ChanceResult.read(buffer));
            Optional<class_3414> soundEventIn = Optional.empty();
            if (buffer.readBoolean() && (holder = class_7923.field_41172.method_40264(buffer.method_44112(class_7924.field_41225))).isPresent() && ((class_6880.class_6883)holder.get()).method_40227()) {
                soundEventIn = Optional.of((class_3414)((class_6880.class_6883)holder.get()).comp_349());
            }
            return new CuttingBoardRecipe(groupIn, inputItemIn, toolIn, (class_2371<ChanceResult>)resultsIn, soundEventIn);
        }

        public static void toNetwork(class_9129 buffer, CuttingBoardRecipe recipe) {
            buffer.method_10814(recipe.group);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.input);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.tool);
            buffer.method_10804(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.write(buffer);
            }
            if (recipe.getSoundEvent().isPresent()) {
                Optional resourceKey = class_7923.field_41172.method_29113((Object)recipe.getSoundEvent().get());
                resourceKey.ifPresentOrElse(rk -> {
                    buffer.method_52964(true);
                    buffer.method_44116(rk);
                }, () -> buffer.method_52964(false));
            } else {
                buffer.method_52964(false);
            }
        }

        public MapCodec<CuttingBoardRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CuttingBoardRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

