/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingSyncPayload;
import net.conczin.immersive_paintings.util.Cache;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class ServerPaintingManager
extends class_18 {
    private static final class_18.class_8645<ServerPaintingManager> TYPE = new class_18.class_8645(ServerPaintingManager::new, ServerPaintingManager::fromNbt, null);
    private static final Codec<Map<class_2960, Painting>> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, Painting.CODEC);
    private static final Set<UUID> sent = new HashSet<UUID>();
    private static Map<class_2960, Map.Entry<Painting, class_3298>> datapackPaintings = new HashMap<class_2960, Map.Entry<Painting, class_3298>>();
    private final Map<class_2960, Painting> customServerPaintings = new HashMap<class_2960, Painting>();
    private static final ServerCache paintingCache = new ServerCache("");
    private static final ServerCache thumbnailCache = new ServerCache("_thumbnail");

    private static ServerPaintingManager get(MinecraftServer server) {
        return (ServerPaintingManager)server.method_30002().method_17983().method_17924(TYPE, "immersive_paintings");
    }

    public static Map<class_2960, Painting> getCustomPaintings(MinecraftServer server) {
        return ServerPaintingManager.get((MinecraftServer)server).customServerPaintings;
    }

    public static Map<class_2960, Map.Entry<Painting, class_3298>> getDatapackPaintings() {
        return datapackPaintings;
    }

    public static void setDatapackPaintings(Map<class_2960, Map.Entry<Painting, class_3298>> datapackPaintings) {
        ServerPaintingManager.datapackPaintings = datapackPaintings;
    }

    public static Optional<Painting> getPainting(MinecraftServer server, class_2960 identifier) {
        if (datapackPaintings.containsKey(identifier)) {
            return Optional.of(datapackPaintings.get(identifier).getKey());
        }
        return Optional.ofNullable(ServerPaintingManager.getCustomPaintings(server).get(identifier));
    }

    public static Optional<byte[]> getImageData(class_2960 identifier, boolean thumbnail) {
        if (datapackPaintings.containsKey(identifier)) {
            Map.Entry<Painting, class_3298> entry = datapackPaintings.get(identifier);
            return paintingCache.getResource(entry.getKey().location(), entry.getValue());
        }
        Optional<Object> image = thumbnail ? thumbnailCache.get(identifier) : paintingCache.get(identifier);
        if (image.isEmpty()) {
            Main.LOGGER.error("no image found with identifier {} [thumb={}] in cache", (Object)identifier, (Object)thumbnail);
        }
        return image;
    }

    public static void registerPainting(MinecraftServer server, class_2960 identifier, Painting painting, BufferedImage image) {
        if (image != null) {
            try {
                paintingCache.set(identifier, ImageManipulations.encode(image));
                thumbnailCache.set(identifier, ImageManipulations.encode(ImageManipulations.resizeImage(image, Painting.Size.THUMBNAIL)));
                ServerPaintingManager.getCustomPaintings(server).put(identifier, painting);
                ServerPaintingManager.get(server).method_78(true);
            }
            catch (IOException e) {
                Main.LOGGER.error("could not register image {}", (Object)identifier, (Object)e);
            }
        }
    }

    public static void deregisterPainting(MinecraftServer server, class_2960 identifier) {
        ServerPaintingManager.getCustomPaintings(server).remove(identifier);
        ServerPaintingManager.get(server).method_78(true);
        paintingCache.delete(identifier);
        thumbnailCache.delete(identifier);
    }

    public static void playerLoggedOut(class_3222 player) {
        sent.remove(player.method_5667());
    }

    public static void playerLoggedIn(class_3222 player) {
        if (!sent.contains(player.method_5667())) {
            HashMap<class_2960, Optional<Painting>> paintings = new HashMap<class_2960, Optional<Painting>>();
            ServerPaintingManager.getDatapackPaintings().forEach((id, entry) -> paintings.put((class_2960)id, Optional.of((Painting)entry.getKey())));
            ServerPaintingManager.getCustomPaintings(player.method_5682()).forEach((id, p) -> paintings.put((class_2960)id, Optional.of(p)));
            List<PaintingSyncPayload> payloads = PaintingSyncPayload.splitPaintings(paintings, true);
            payloads.forEach(payload -> NetworkHandler.sendToClient(player, payload));
            sent.add(player.method_5667());
        }
    }

    public static ServerPaintingManager fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        ServerPaintingManager m = new ServerPaintingManager();
        Map paintings = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("paintings")).result().orElse(new HashMap());
        paintings.forEach((id, painting) -> {
            if (!paintingCache.exists(id)) {
                return;
            }
            if (!thumbnailCache.exists(id)) {
                try {
                    Optional source = paintingCache.get(id);
                    if (source.isPresent()) {
                        thumbnailCache.set(id, ImageManipulations.encode(ImageManipulations.resizeImage(ImageManipulations.decode((byte[])source.get()), Painting.Size.THUMBNAIL)));
                    }
                }
                catch (IOException e) {
                    Main.LOGGER.error("could not create thumbnail from stored image", (Throwable)e);
                }
            }
            m.customServerPaintings.put((class_2960)id, (Painting)painting);
        });
        return m;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.customServerPaintings).result().ifPresent(tag -> nbt.method_10566("paintings", tag));
        return nbt;
    }

    private static class ServerCache
    extends Cache<class_2960, byte[]> {
        private String suffix = ".png";

        public ServerCache(String suffix) {
            this.suffix = suffix + this.suffix;
        }

        @Override
        public String getCachePath(class_2960 key) {
            return key.method_12832() + this.suffix;
        }

        public Optional<byte[]> getResource(class_2960 key, class_3298 resource) {
            Optional<byte[]> optional;
            block9: {
                Optional<byte[]> data = this.get(key);
                if (data.isPresent()) {
                    return data;
                }
                InputStream stream = resource.method_14482();
                try {
                    byte[] bytes = stream.readAllBytes();
                    this.set(key, bytes);
                    optional = Optional.of(bytes);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return optional;
        }

        @Override
        public byte[] decode(byte[] bytes) {
            return bytes;
        }

        @Override
        public byte[] encode(byte[] image) {
            return image;
        }
    }
}

