/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.client.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.client.gui.widget.IntegerSliderWidget;
import net.conczin.immersive_paintings.client.gui.widget.PaintingWidget;
import net.conczin.immersive_paintings.client.gui.widget.PercentageSliderWidget;
import net.conczin.immersive_paintings.client.gui.widget.TexturedButtonWidget;
import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.network.LazyNetworkManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.c2s.ImageUploadPayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingDeletePayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingEditPayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingRegisterPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.resources.FrameLoader;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ImmersivePaintingScreen
extends class_437 {
    private static final int SCREENSHOTS_PER_PAGE = 5;
    final int minResolution;
    final int maxResolution;
    final boolean showOtherPlayersPaintings;
    final int uploadPermissionLevel;
    public final ImmersivePaintingEntity entity;
    private String filteredString = "";
    private int filteredResolution = 0;
    private int filteredWidth = 0;
    private int filteredHeight = 0;
    private final List<class_2960> filteredPaintings = new ArrayList<class_2960>();
    private int selectionPage;
    private Page page;
    private class_4185 pageWidget;
    private final Map<class_2960, PaintingWidget> paintingWidgets = new HashMap<class_2960, PaintingWidget>();
    private BufferedImage currentImage;
    private static int currentImagePixelZoomCache = -1;
    private String currentImageName;
    private PixelatorSettings settings;
    private BufferedImage pixelatedImage;
    private List<File> screenshots = List.of();
    private int screenshotPage;
    private class_2960 deletePainting;
    private class_2561 error;
    private boolean shouldReProcess;
    private static volatile boolean shouldUpload;
    private static final ExecutorService service;

    public ImmersivePaintingScreen(int entityId, int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) {
        super((class_2561)class_2561.method_43471((String)"item.immersive_paintings.painting"));
        ImmersivePaintingEntity painting;
        class_1297 class_12972;
        this.minResolution = minResolution;
        this.maxResolution = maxResolution;
        this.showOtherPlayersPaintings = showOtherPlayersPaintings && Configs.CLIENT.showOtherPlayersPaintings;
        this.uploadPermissionLevel = uploadPermissionLevel;
        this.entity = class_310.method_1551().field_1687 != null && (class_12972 = class_310.method_1551().field_1687.method_8469(entityId)) instanceof ImmersivePaintingEntity ? (painting = (ImmersivePaintingEntity)class_12972) : null;
        if (this.entity == null) {
            this.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.page == null) {
            this.setPage(Page.DATAPACKS);
        } else {
            this.refreshPage();
        }
        File file = new File(class_310.method_1551().field_1697, "screenshots");
        File[] files = file.listFiles(v -> v.getName().endsWith(".png"));
        if (files != null) {
            this.screenshots = Arrays.stream(files).toList();
        }
    }

    private void clearSearch() {
        this.filteredString = "";
        this.filteredResolution = 0;
        this.filteredWidth = 0;
        this.filteredHeight = 0;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        switch (this.page.ordinal()) {
            case 3: {
                graphics.method_25294(this.field_22789 / 2 - 115, this.field_22790 / 2 - 68, this.field_22789 / 2 + 115, this.field_22790 / 2 - 41, 0x50000000);
                List<class_2561> wrap = ImmersivePaintingScreen.wrap((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.drop"), 220);
                int y = this.field_22790 / 2 - 40 - wrap.size() * 12;
                for (class_2561 text : wrap) {
                    graphics.method_27534(this.field_22793, text, this.field_22789 / 2, y, -1);
                    y += 12;
                }
                break;
            }
            case 4: {
                if (this.shouldReProcess && this.currentImage != null) {
                    service.submit(() -> this.pixelateImage());
                    this.shouldReProcess = false;
                }
                if (shouldUpload && this.pixelatedImage != null) {
                    class_310.method_1551().method_1531().method_4616(Main.locate("temp_pixelated"), (class_1044)new class_1043(ImageManipulations.bufferedToNative(this.pixelatedImage)));
                }
                int maxWidth = 190;
                int maxHeight = 135;
                int tw = this.settings.resolution * this.settings.width;
                int th = this.settings.resolution * this.settings.height;
                float size = Math.min((float)maxWidth / (float)tw, (float)maxHeight / (float)th);
                class_4587 poseStack = graphics.method_51448();
                poseStack.method_22903();
                poseStack.method_46416((float)this.field_22789 / 2.0f - (float)tw * size / 2.0f, (float)this.field_22790 / 2.0f - (float)th * size / 2.0f, 0.0f);
                poseStack.method_22905(size, size, 1.0f);
                graphics.method_25290(Main.locate("temp_pixelated"), 0, 0, 0.0f, 0.0f, tw, th, tw, th);
                poseStack.method_22909();
                if (this.error == null) break;
                graphics.method_27534(this.field_22793, this.error, this.field_22789 / 2, this.field_22790 / 2, -65536);
                break;
            }
            case 6: {
                graphics.method_25294(this.field_22789 / 2 - 160, this.field_22790 / 2 - 50, this.field_22789 / 2 + 160, this.field_22790 / 2 + 50, -2013265920);
                List<class_2561> wrap = ImmersivePaintingScreen.wrap((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.confirm_deletion"), 300);
                int y = this.field_22790 / 2 - 35;
                for (class_2561 t : wrap) {
                    graphics.method_27534(this.field_22793, t, this.field_22789 / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case 7: {
                graphics.method_25294(this.field_22789 / 2 - 160, this.field_22790 / 2 - 50, this.field_22789 / 2 + 160, this.field_22790 / 2 + 50, -2013265920);
                List<class_2561> wrap = ImmersivePaintingScreen.wrap((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.confirm_admin_deletion"), 300);
                int y = this.field_22790 / 2 - 35;
                for (class_2561 t : wrap) {
                    graphics.method_27534(this.field_22793, t, this.field_22789 / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case 8: {
                class_5250 text = class_2561.method_43469((String)"immersive_paintings.gui.upload", (Object[])new Object[]{(int)Math.ceil(LazyNetworkManager.getRemainingTime())});
                graphics.method_27534(this.field_22793, (class_2561)text, this.field_22789 / 2, this.field_22790 / 2, -1);
            }
        }
    }

    private List<class_2960> getMaterialsList(class_2960 frame) {
        return FrameLoader.frames.values().stream().filter(v -> v.frame().equals((Object)frame)).map(FrameLoader.Frame::material).distinct().sorted(class_2960::method_12833).toList();
    }

    private void rebuild() {
        int x;
        this.method_37067();
        if (this.page != Page.CREATE) {
            LinkedList<Page> b = new LinkedList<Page>();
            b.add(Page.YOURS);
            b.add(Page.DATAPACKS);
            if (this.showOtherPlayersPaintings || this.isOp()) {
                b.add(Page.PLAYERS);
            }
            if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1724.method_5687(this.uploadPermissionLevel)) {
                b.add(Page.NEW);
            }
            if (!this.entity.isGraffiti()) {
                b.add(Page.FRAME);
            }
            x = this.field_22789 / 2 - 200;
            int w2 = 400 / b.size();
            for (Page page : b) {
                class_4185 btn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)("immersive_paintings.gui.page." + page.name().toLowerCase(Locale.ROOT))), sender -> this.setPage(page)).method_46434(x, this.field_22790 / 2 - 90 - 22, w2, 20).method_46431());
                btn.field_22763 = page != this.page;
                x += w2;
            }
        }
        switch (this.page.ordinal()) {
            case 3: {
                class_342 editBox = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 90, this.field_22790 / 2 - 38, 180, 16, (class_2561)class_2561.method_43470((String)"URL")));
                editBox.method_1880(1024);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.load"), sender -> this.loadImage(editBox.method_1882())).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 - 15, 100, 20).method_46431());
                this.rebuildScreenshots();
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<<"), sender -> this.setScreenshotPage(this.screenshotPage - 1)).method_46434(this.field_22789 / 2 - 65, this.field_22790 / 2 + 70, 30, 20).method_46431());
                this.pageWidget = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)""), sender -> {}).method_46434(this.field_22789 / 2 - 65 + 30, this.field_22790 / 2 + 70, 70, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">>"), sender -> this.setScreenshotPage(this.screenshotPage + 1)).method_46434(this.field_22789 / 2 - 65 + 100, this.field_22790 / 2 + 70, 30, 20).method_46431());
                this.setScreenshotPage(this.screenshotPage);
                break;
            }
            case 4: {
                class_342 editBox = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 90, this.field_22790 / 2 - 100, 180, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.gui.name")));
                editBox.method_1880(256);
                editBox.method_1852(this.currentImageName);
                editBox.method_1863(s -> {
                    this.currentImageName = s;
                });
                int y = this.field_22790 / 2 - 60;
                this.method_37063((class_364)new IntegerSliderWidget(this.field_22789 / 2 - 200, y, 100, 20, "immersive_paintings.gui.width", (double)this.settings.width, 1, 16, v -> {
                    this.settings.width = v;
                    this.shouldReProcess = true;
                }));
                this.method_37063((class_364)new IntegerSliderWidget(this.field_22789 / 2 - 200, y += 22, 100, 20, "immersive_paintings.gui.height", (double)this.settings.height, 1, 16, v -> {
                    this.settings.height = v;
                    this.shouldReProcess = true;
                }));
                int x2 = this.field_22789 / 2 - 200;
                class_4185 resolutionWidget = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(this.settings.resolution)), sender -> {}).method_46433(x2 + 25, y += 22).method_46437(50, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.resolution"))).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), sender -> {
                    this.settings.resolution = Math.max(this.minResolution, this.settings.resolution / 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    resolutionWidget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.settings.resolution)));
                }).method_46433(x2, y).method_46437(25, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.resolution"))).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), sender -> {
                    this.settings.resolution = Math.min(this.maxResolution, this.settings.resolution * 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    resolutionWidget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.settings.resolution)));
                }).method_46433(x2 + 75, y).method_46437(25, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.resolution"))).method_46431());
                y += 22;
                ((IntegerSliderWidget)this.method_37063((class_364)new IntegerSliderWidget((int)(this.field_22789 / 2 - 200), (int)(y += 10), (int)100, (int)20, (String)"immersive_paintings.gui.colors", (double)((double)this.settings.colors), (int)2, (int)25, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$14(java.lang.Integer ), (Ljava/lang/Integer;)V)((ImmersivePaintingScreen)this)))).field_22763 = !this.settings.pixelArt;
                ((PercentageSliderWidget)this.method_37063((class_364)new PercentageSliderWidget((int)(this.field_22789 / 2 - 200), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.gui.dither", (double)this.settings.dither, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$15(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).field_22763 = !this.settings.pixelArt;
                y = this.field_22790 / 2 - 50;
                this.method_37063((class_364)class_4286.method_54787((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.pixelart"), (class_327)this.field_22793).method_54789(this.field_22789 / 2 + 100, y).method_54794(this.settings.pixelArt).method_54793(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.pixelart.tooltip"))).method_54791((w, v) -> {
                    this.settings.pixelArt = v;
                    this.adaptToPixelArt();
                    this.refreshPage();
                    this.shouldReProcess = true;
                }).method_54788());
                this.method_37063((class_364)class_4286.method_54787((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.hide"), (class_327)this.field_22793).method_54789(this.field_22789 / 2 + 100, y += 22).method_54794(this.settings.hidden).method_54793(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.visibility"))).method_54791((w, v) -> {
                    this.settings.hidden = !this.settings.hidden;
                }).method_54788());
                this.method_37063((class_364)class_4286.method_54787((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.nsfw"), (class_327)this.field_22793).method_54789(this.field_22789 / 2 + 100, y += 22).method_54794(this.settings.nsfw).method_54793(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.nsfw"))).method_54791((w, v) -> {
                    this.settings.nsfw = !this.settings.nsfw;
                }).method_54788());
                this.method_37063((class_364)new PercentageSliderWidget(this.field_22789 / 2 + 100, y += 22, 100, 20, "immersive_paintings.gui.x_offset", this.settings.offsetX, v -> {
                    this.settings.offsetX = v;
                    this.shouldReProcess = true;
                }));
                this.method_37063((class_364)new PercentageSliderWidget(this.field_22789 / 2 + 100, y += 22, 100, 20, "immersive_paintings.gui.y_offset", this.settings.offsetY, v -> {
                    this.settings.offsetY = v;
                    this.shouldReProcess = true;
                }));
                ((PercentageSliderWidget)this.method_37063((class_364)new PercentageSliderWidget((int)(this.field_22789 / 2 + 100), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.gui.zoom", (double)this.settings.zoom, (double)(this.entity.isGraffiti() ? 0.5 : 1.0), (double)(this.entity.isGraffiti() ? 1.5 : 3.0), (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$21(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).field_22763 = !this.settings.pixelArt;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.cancel"), v -> this.setPage(Page.NEW)).method_46434(this.field_22789 / 2 - 85, this.field_22790 / 2 + 75, 80, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.save"), v -> {
                    byte[] encoded;
                    try {
                        encoded = ImageManipulations.encode(this.pixelatedImage);
                    }
                    catch (IOException e) {
                        Main.LOGGER.error("could not encode temp image", (Throwable)e);
                        return;
                    }
                    ImageManipulations.processByteArrayInChunks(encoded, (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new ImageUploadPayload((byte[])ints, (int)split, (int)splits))));
                    EnumSet<Painting.Flag> flags = this.settings.getFlags();
                    if (this.entity.isGraffiti()) {
                        flags.add(Painting.Flag.GRAFFITI);
                    }
                    LazyNetworkManager.sendToServer(new PaintingRegisterPayload(this.settings.width, this.settings.height, this.settings.resolution, this.currentImageName, flags));
                    this.setPage(Page.LOADING);
                }).method_46434(this.field_22789 / 2 + 5, this.field_22790 / 2 + 75, 80, 20).method_46431());
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.rebuildPaintings();
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<<"), sender -> this.setSelectionPage(this.selectionPage - 1)).method_46434(this.field_22789 / 2 - 35 - 30, this.field_22790 / 2 + 80, 30, 20).method_46431());
                this.pageWidget = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)""), sender -> {}).method_46434(this.field_22789 / 2 - 35, this.field_22790 / 2 + 80, 70, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">>"), sender -> this.setSelectionPage(this.selectionPage + 1)).method_46434(this.field_22789 / 2 + 35, this.field_22790 / 2 + 80, 30, 20).method_46431());
                this.setSelectionPage(this.selectionPage);
                class_342 editBox = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 65, this.field_22790 / 2 - 88, 130, 16, (class_2561)class_2561.method_43471((String)"immersive_paintings.gui.search")));
                editBox.method_1880(64);
                editBox.method_1887("search");
                editBox.method_1863(s -> {
                    this.filteredString = s;
                    this.updateSearch();
                    editBox.method_1887(null);
                });
                x = this.field_22789 / 2 - 200 + 12;
                class_4185 widget = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)), sender -> {}).method_46433(x + 50 + 8, this.field_22790 / 2 - 90).method_46437(25, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.filter_resolution"))).method_46431());
                class_4185 allWidget = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.filter_all"), sender -> {
                    this.filteredResolution = 0;
                    this.updateSearch();
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)));
                    sender.field_22763 = false;
                }).method_46433(x, this.field_22790 / 2 - 90).method_46437(25, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.filter_resolution"))).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), sender -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.max(this.minResolution, this.filteredResolution / 2);
                    this.updateSearch();
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)));
                    allWidget.field_22763 = true;
                }).method_46433(x + 25 + 8, this.field_22790 / 2 - 90).method_46437(25, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.filter_resolution"))).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), sender -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.min(this.maxResolution, this.filteredResolution * 2);
                    this.updateSearch();
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)));
                    allWidget.field_22763 = true;
                }).method_46433(x + 75 + 8, this.field_22790 / 2 - 90).method_46437(25, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.tooltip.filter_resolution"))).method_46431());
                class_342 widthWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 + 80, this.field_22790 / 2 - 88, 40, 16, (class_2561)class_2561.method_43471((String)"immersive_paintings.gui.filter_width")));
                widthWidget.method_1880(2);
                widthWidget.method_1887("width");
                widthWidget.method_1863(s -> {
                    try {
                        this.filteredWidth = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredWidth = 0;
                    }
                    this.updateSearch();
                    widthWidget.method_1887(null);
                });
                class_342 heightWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 + 80 + 40, this.field_22790 / 2 - 88, 40, 16, (class_2561)class_2561.method_43471((String)"immersive_paintings.gui.filter_height")));
                heightWidget.method_1880(2);
                heightWidget.method_1887("height");
                heightWidget.method_1863(s -> {
                    try {
                        this.filteredHeight = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredHeight = 0;
                    }
                    this.updateSearch();
                    heightWidget.method_1887(null);
                });
                break;
            }
            case 5: {
                int y = this.field_22790 / 2 - 80;
                List<class_2960> frames = FrameLoader.frames.values().stream().map(FrameLoader.Frame::frame).distinct().sorted(class_2960::method_12833).toList();
                for (class_2960 frame : frames) {
                    class_4185 widget = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)("immersive_paintings.frame." + ImmersivePaintingScreen.identifierToTranslation(frame))), v -> {
                        class_2960 material = this.getMaterialsList(frame).getFirst();
                        this.entity.setFrame(frame);
                        this.entity.setMaterial(material);
                        NetworkHandler.Client.sendToServer(new PaintingEditPayload(this.entity.method_5628(), Map.of(PaintingEditPayload.Option.FRAME, frame.toString(), PaintingEditPayload.Option.MATERIAL, material.toString())));
                        this.setPage(Page.FRAME);
                    }).method_46434(this.field_22789 / 2 - 200, y, 100, 20).method_46431());
                    widget.field_22763 = !frame.equals((Object)this.entity.getFrame());
                    y += 25;
                }
                int py = 0;
                int px = 0;
                List<class_2960> materials = this.getMaterialsList(this.entity.getFrame());
                LinkedList<class_4185> materialList = new LinkedList<class_4185>();
                for (class_2960 material : materials) {
                    class_4185 widget = (class_4185)this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2 - 80 + px * 65, this.field_22790 / 2 - 80 + py * 20, 64, 16, class_2960.method_60655((String)material.method_12836(), (String)material.method_12832().replace("/block/", "/gui/")), 64, 32, (class_2561)class_2561.method_43470((String)""), v -> {
                        this.entity.setMaterial(material);
                        NetworkHandler.Client.sendToServer(new PaintingEditPayload(this.entity.method_5628(), Map.of(PaintingEditPayload.Option.MATERIAL, material.toString())));
                        materialList.forEach(b -> {
                            b.field_22763 = true;
                        });
                        v.field_22763 = false;
                    }));
                    class_7919 paintingTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)("immersive_paintings.material." + ImmersivePaintingScreen.identifierToTranslation(material))));
                    widget.method_47400(paintingTooltip);
                    widget.field_22763 = !material.equals((Object)this.entity.getMaterial());
                    materialList.add(widget);
                    if (++px <= 3) continue;
                    px = 0;
                    ++py;
                }
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.done"), v -> this.method_25419()).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 + 70, 100, 20).method_46431());
                break;
            }
            case 6: {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.cancel"), v -> this.setPage(Page.YOURS)).method_46434(this.field_22789 / 2 - 100 - 5, this.field_22790 / 2 + 20, 100, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.delete"), v -> {
                    NetworkHandler.Client.sendToServer(new PaintingDeletePayload(this.deletePainting, false));
                    this.setPage(Page.YOURS);
                }).method_46434(this.field_22789 / 2 + 5, this.field_22790 / 2 + 20, 100, 20).method_46431());
                break;
            }
            case 7: {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.cancel"), v -> this.setPage(Page.PLAYERS)).method_46434(this.field_22789 / 2 - 115, this.field_22790 / 2 + 10, 70, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.delete"), v -> {
                    NetworkHandler.Client.sendToServer(new PaintingDeletePayload(this.deletePainting, false));
                    this.setPage(Page.PLAYERS);
                }).method_46434(this.field_22789 / 2 - 40, this.field_22790 / 2 + 10, 70, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.delete_all"), v -> {
                    NetworkHandler.Client.sendToServer(new PaintingDeletePayload(this.deletePainting, true));
                    this.setPage(Page.PLAYERS);
                }).method_46434(this.field_22789 / 2 + 35, this.field_22790 / 2 + 10, 70, 20).method_46431());
            }
        }
    }

    public void updateWidget(class_2960 identifier) {
        if (this.paintingWidgets.containsKey(identifier)) {
            ClientPaintingManager.getPainting(identifier).ifPresent(p -> this.paintingWidgets.get(identifier).update(ClientPaintingManager.getImageIdentifier(identifier, Painting.Size.THUMBNAIL), p.width(), p.height()));
        }
    }

    public static String identifierToTranslation(class_2960 location) {
        String s = location.method_12832();
        String lastSplit = s.substring(s.lastIndexOf("/") + 1);
        int i = lastSplit.lastIndexOf(".");
        return i < 0 ? lastSplit : lastSplit.substring(0, i);
    }

    public static List<class_2561> wrap(class_2561 text, int maxWidth) {
        return class_310.method_1551().field_1772.method_27527().method_27495((class_5348)text, maxWidth, class_2583.field_24360).stream().map(line -> {
            class_5250 compiled = class_2561.method_43470((String)"");
            line.method_27658((s, t) -> {
                compiled.method_10852((class_2561)class_2561.method_43470((String)t).method_10862(s));
                return Optional.empty();
            }, text.method_10866());
            return compiled;
        }).collect(Collectors.toList());
    }

    private static class_2561 consolidate(List<class_2561> textList) {
        if (textList == null) {
            return null;
        }
        class_5250 base = class_2561.method_43473();
        class_5250 lastTextNode = base.method_27661();
        if (textList.isEmpty()) {
            return base;
        }
        for (int i = 0; i < textList.size() - 1; ++i) {
            class_2561 text = textList.get(i);
            lastTextNode = lastTextNode.method_10852(text).method_27693("\n");
        }
        class_2561 finalElement = textList.getLast();
        return lastTextNode.method_10852(finalElement);
    }

    private void rebuildPaintings() {
        this.paintingWidgets.forEach((id, widget) -> this.method_37066((class_364)widget));
        this.paintingWidgets.clear();
        for (int y = 0; y < 3; ++y) {
            int i;
            for (int x = 0; x < 8 && (i = y * 8 + x + this.selectionPage * 24) >= 0 && i < this.filteredPaintings.size(); ++x) {
                class_2960 identifier = this.filteredPaintings.get(i);
                LinkedList<class_2561> tooltip = new LinkedList<class_2561>();
                ClientPaintingManager.getPainting(identifier).ifPresent(p -> {
                    tooltip.add((class_2561)class_2561.method_43470((String)p.name()));
                    tooltip.add((class_2561)class_2561.method_43469((String)"immersive_paintings.gui.by_author", (Object[])new Object[]{p.author()}).method_27692(class_124.field_1056));
                    tooltip.add((class_2561)class_2561.method_43469((String)"immersive_paintings.gui.resolution", (Object[])new Object[]{p.width(), p.height(), p.resolution()}).method_27692(class_124.field_1056));
                    if (this.page == Page.YOURS && p.has(Painting.Flag.HIDDEN)) {
                        tooltip.add((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.hidden").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                    }
                    if (this.page == Page.YOURS && p.has(Painting.Flag.NSFW)) {
                        tooltip.add((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.nsfw").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                    }
                    if (this.page == Page.YOURS || this.page == Page.PLAYERS && this.isOp()) {
                        tooltip.add((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.right_click_to_delete").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                    }
                });
                PaintingWidget paintingWidget = (PaintingWidget)this.method_37063((class_364)new PaintingWidget((int)((double)this.field_22789 / 2.0 + ((double)x - 3.5) * 48.0) - 24, this.field_22790 / 2 - 66 + y * 48, 46, 46, sender -> {
                    NetworkHandler.Client.sendToServer(new PaintingEditPayload(this.entity.method_5628(), Map.of(PaintingEditPayload.Option.MOTIVE, identifier.toString())));
                    if (this.entity.isGraffiti()) {
                        this.method_25419();
                    } else {
                        this.setPage(Page.FRAME);
                    }
                }, sender -> {
                    if (this.page == Page.YOURS) {
                        this.deletePainting = identifier;
                        this.setPage(Page.DELETE);
                    } else if (this.page == Page.PLAYERS && this.isOp()) {
                        this.deletePainting = identifier;
                        this.setPage(Page.ADMIN_DELETE);
                    }
                }));
                paintingWidget.method_47400(class_7919.method_47407((class_2561)ImmersivePaintingScreen.consolidate(tooltip)));
                this.paintingWidgets.put(identifier, paintingWidget);
                this.updateWidget(identifier);
            }
        }
    }

    private void rebuildScreenshots() {
        int i;
        this.paintingWidgets.forEach((id, widget) -> this.method_37066((class_364)widget));
        this.paintingWidgets.clear();
        for (int x = 0; x < 5 && (i = x + this.screenshotPage * 5) >= 0 && i < this.screenshots.size(); ++x) {
            File file = this.screenshots.get(i);
            PaintingWidget paintingWidget = (PaintingWidget)this.method_37063((class_364)new PaintingWidget(this.field_22789 / 2 + (x - 2) * 68 - 32, this.field_22790 / 2 + 15, 64, 48, b -> {
                this.currentImage = ((PaintingWidget)b).getImage();
                if (this.currentImage != null) {
                    currentImagePixelZoomCache = -1;
                    this.currentImageName = file.getName();
                    this.settings = new PixelatorSettings(this.currentImage, this.minResolution, this.maxResolution);
                    this.setPage(Page.CREATE);
                    this.pixelateImage();
                }
            }, b -> {}));
            paintingWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)file.getName())));
            class_2960 identifier = Main.locate("screenshot_" + x);
            this.paintingWidgets.put(identifier, paintingWidget);
            service.submit(() -> {
                BufferedImage image = this.loadImage(file.getPath(), identifier);
                if (image != null) {
                    paintingWidget.update(identifier, image);
                }
            });
        }
    }

    public void setPage(Page page) {
        if (page != this.page) {
            this.clearSearch();
        }
        this.page = page;
        this.filteredResolution = page == Page.DATAPACKS ? 32 : 0;
        this.rebuild();
        if (page == Page.DATAPACKS || page == Page.PLAYERS || page == Page.YOURS) {
            this.updateSearch();
        }
    }

    private void updateSearch() {
        this.filteredPaintings.clear();
        class_746 player = class_310.method_1551().field_1724;
        UUID uuid = player == null ? null : player.method_5667();
        this.filteredPaintings.addAll(ClientPaintingManager.getPaintings().entrySet().stream().filter(e -> {
            Painting p = (Painting)e.getValue();
            return !((this.page != Page.YOURS || p.is(Painting.Type.DATAPACK) || !p.authorUUID().equals(uuid)) && (this.page != Page.PLAYERS || p.is(Painting.Type.DATAPACK) || p.has(Painting.Flag.HIDDEN) && !this.isOp() || p.has(Painting.Flag.NSFW) && !Configs.CLIENT.showNSFWPaintings && !this.isOp()) && (this.page != Page.DATAPACKS || !p.is(Painting.Type.DATAPACK)) || p.has(Painting.Flag.GRAFFITI) != this.entity.isGraffiti() || !((class_2960)e.getKey()).toString().contains(this.filteredString) || this.filteredResolution != 0 && p.resolution() != this.filteredResolution || this.filteredWidth != 0 && p.width() != this.filteredWidth || this.filteredHeight != 0 && p.height() != this.filteredHeight);
        }).sorted(Comparator.comparing(p -> ((Painting)p.getValue()).name())).map(Map.Entry::getKey).toList());
        this.setSelectionPage(this.selectionPage);
    }

    private boolean isOp() {
        return class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5687(4);
    }

    private void setSelectionPage(int p) {
        int maxPages = (int)Math.ceil((double)this.filteredPaintings.size() / 24.0);
        this.selectionPage = Math.min(maxPages - 1, Math.max(0, p));
        this.rebuildPaintings();
        this.pageWidget.method_25355((class_2561)class_2561.method_43470((String)(this.selectionPage + 1 + " / " + maxPages)));
    }

    private void setScreenshotPage(int p) {
        int maxPages = (int)Math.ceil((double)this.screenshots.size() / 8.0);
        int oldPage = this.screenshotPage;
        this.screenshotPage = Math.min(maxPages - 1, Math.max(0, p));
        if (oldPage != this.screenshotPage) {
            this.rebuildScreenshots();
        }
        this.pageWidget.method_25355((class_2561)class_2561.method_43470((String)(this.screenshotPage + 1 + " / " + maxPages)));
    }

    public void method_29638(List<Path> paths) {
        this.loadImage(paths.getFirst().toString());
    }

    private void loadImage(String path) {
        this.currentImage = this.loadImage(path, Main.locate("temp"));
        currentImagePixelZoomCache = -1;
        if (this.currentImage != null) {
            this.currentImageName = FilenameUtils.getBaseName((String)path).replaceFirst("[.][^.]+$", "");
            this.settings = new PixelatorSettings(this.currentImage, this.minResolution, this.maxResolution);
            this.setPage(Page.CREATE);
            this.pixelateImage();
        }
    }

    private BufferedImage loadImage(String path, class_2960 identifier) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                Main.LOGGER.error("failed loading image {} from path {}", (Object)identifier, (Object)path, (Object)e);
            }
        }
        if (stream != null) {
            try {
                BufferedImage image = ImageIO.read(stream);
                if (image != null) {
                    this.preprocessImage(image);
                    class_310.method_1551().method_1531().method_4616(identifier, (class_1044)new class_1043(ImageManipulations.bufferedToNative(image)));
                    stream.close();
                    return image;
                }
            }
            catch (IOException e) {
                Main.LOGGER.error("failed decoding image {} from path {}", (Object)identifier, (Object)path, (Object)e);
            }
        }
        return null;
    }

    private void preprocessImage(BufferedImage image) {
        this.clearError();
        if (!this.entity.isGraffiti()) {
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int color = image.getRGB(x, y);
                    int alpha = color >> 24 & 0xFF;
                    if (alpha == 255) continue;
                    if (this.error == null) {
                        this.setError((class_2561)class_2561.method_43471((String)"immersive_paintings.gui.graffiti_warning"));
                    }
                    color = 0xFF000000 | color & 0xFFFFFF;
                    image.setRGB(x, y, color);
                }
            }
        }
    }

    private static int getCurrentImagePixelZoomCache(BufferedImage currentImage) {
        if (currentImagePixelZoomCache < 0) {
            currentImagePixelZoomCache = ImageManipulations.scanForPixelArtMultiple(currentImage);
        }
        return currentImagePixelZoomCache;
    }

    private void adaptToPixelArt() {
        double zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(this.currentImage);
        this.settings.width = Math.max(1, Math.min(16, (int)((double)this.currentImage.getWidth() / zoom / (double)this.settings.resolution)));
        this.settings.height = Math.max(1, Math.min(16, (int)((double)this.currentImage.getHeight() / zoom / (double)this.settings.resolution)));
    }

    private void pixelateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
        shouldUpload = true;
    }

    public static BufferedImage pixelateImage(BufferedImage currentImage, PixelatorSettings settings) {
        float zoom;
        BufferedImage pixelatedImage = new BufferedImage(settings.resolution * settings.width, settings.resolution * settings.height, 2);
        if (settings.pixelArt) {
            zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(currentImage);
        } else {
            float fx = (float)currentImage.getWidth() / (float)pixelatedImage.getWidth();
            float fy = (float)currentImage.getHeight() / (float)pixelatedImage.getHeight();
            zoom = (float)((double)Math.min(fx, fy) / settings.zoom);
        }
        int ox = (int)((double)((float)currentImage.getWidth() - (float)pixelatedImage.getWidth() * zoom) * settings.offsetX);
        int oy = (int)((double)((float)currentImage.getHeight() - (float)pixelatedImage.getHeight() * zoom) * settings.offsetY);
        if (settings.pixelArt) {
            ox = ox / (int)zoom * (int)zoom;
            oy = oy / (int)zoom * (int)zoom;
        }
        ImageManipulations.resize(pixelatedImage, currentImage, zoom, ox, oy);
        if (settings.dither > 0.0 && !settings.pixelArt) {
            if (settings.colors > 1) {
                ImageManipulations.dither(pixelatedImage, settings.dither / (double)settings.colors);
            } else {
                ImageManipulations.dither(pixelatedImage, settings.dither / 16.0);
            }
        }
        if (settings.colors > 1 && !settings.pixelArt) {
            ImageManipulations.reduceColors(pixelatedImage, settings.colors);
        }
        return pixelatedImage;
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(class_2561 text) {
        this.error = text;
    }

    private /* synthetic */ void lambda$rebuild$21(Double v) {
        this.settings.zoom = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$15(Double v) {
        this.settings.dither = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$14(Integer v) {
        this.settings.colors = v;
        this.shouldReProcess = true;
    }

    static {
        service = Executors.newFixedThreadPool(1);
    }

    public static enum Page {
        YOURS,
        DATAPACKS,
        PLAYERS,
        NEW,
        CREATE,
        FRAME,
        DELETE,
        ADMIN_DELETE,
        LOADING;

    }

    public static final class PixelatorSettings {
        public double dither;
        public int colors;
        public int resolution;
        public int width;
        public int height;
        public double offsetX;
        public double offsetY;
        public double zoom;
        public boolean pixelArt;
        public boolean hidden = true;
        public boolean nsfw;

        public PixelatorSettings(double dither, int colors, int resolution, int width, int height, double offsetX, double offsetY, double zoom, boolean pixelArt) {
            this.dither = dither;
            this.colors = colors;
            this.resolution = resolution;
            this.width = width;
            this.height = height;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.zoom = zoom;
            this.pixelArt = pixelArt;
        }

        PixelatorSettings(BufferedImage currentImage, int minResolution, int maxResolution) {
            this(0.0, 10, Math.clamp(64L, minResolution, maxResolution), 1, 1, 0.5, 0.5, 1.0, false);
            double target = (double)currentImage.getWidth() / (double)currentImage.getHeight();
            double bestScore = 100.0;
            double d = Math.sqrt(currentImage.getWidth() * currentImage.getWidth() + currentImage.getHeight() * currentImage.getHeight());
            double dw = (double)currentImage.getWidth() / d;
            double dh = (double)currentImage.getHeight() / d;
            for (double diagonal = 3.0; diagonal < 6.0; diagonal += target) {
                int ph;
                int pw = (int)Math.ceil(dw * diagonal);
                double e = Math.abs((double)pw / (double)(ph = (int)Math.ceil(dh * diagonal)) - target) * Math.sqrt(5 + this.width + this.height);
                if (!(e < bestScore)) continue;
                this.width = Math.max(1, Math.min(16, pw));
                this.height = Math.max(1, Math.min(16, ph));
                bestScore = e;
            }
        }

        public EnumSet<Painting.Flag> getFlags() {
            EnumSet<Painting.Flag> flags = EnumSet.noneOf(Painting.Flag.class);
            if (this.nsfw) {
                flags.add(Painting.Flag.NSFW);
            }
            if (this.hidden) {
                flags.add(Painting.Flag.HIDDEN);
            }
            return flags;
        }
    }
}

