/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network;

import java.util.LinkedList;
import java.util.List;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.class_3222;

public class LazyNetworkManager {
    private static final List<LazyPacket> serverQueue = new LinkedList<LazyPacket>();
    private static final List<LazyPacket> clientQueue = new LinkedList<LazyPacket>();
    private static double cooldownClient = 0.0;
    private static double cooldownServer = 0.0;

    public static void sendToServer(ImmersivePayload payload) {
        serverQueue.add(new LazyPacket(payload, null));
    }

    public static void sendToClient(ImmersivePayload payload, class_3222 e) {
        clientQueue.add(new LazyPacket(payload, e));
    }

    public static void tickClient() {
        for (cooldownClient = Math.max(cooldownClient - 1.0, 0.0); !serverQueue.isEmpty() && cooldownClient < 1.0; cooldownClient += 20.0 / (double)Configs.COMMON.maxPacketsPerSecond) {
            LazyPacket packet = serverQueue.removeFirst();
            NetworkHandler.Client.sendToServer(packet.payload());
        }
    }

    public static void tickServer() {
        for (cooldownServer = Math.max(cooldownServer - 1.0, 0.0); !clientQueue.isEmpty() && cooldownServer < 1.0; cooldownServer += 20.0 / (double)Configs.COMMON.maxPacketsPerSecond) {
            LazyPacket packet = clientQueue.removeFirst();
            NetworkHandler.sendToClient(packet.player, packet.payload());
        }
    }

    public static float getRemainingTime() {
        return (float)serverQueue.size() / (float)Configs.COMMON.maxPacketsPerSecond;
    }

    record LazyPacket(ImmersivePayload payload, class_3222 player) {
    }
}

