/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.datagen.provider;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import dev.upcraft.sparkweave.api.datagen.ContextAwarePackOutput;
import dev.upcraft.sparkweave.api.datagen.TranslationBuilder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class SparkweaveLanguageProvider
implements class_2405 {
    private final Map<String, String> extraTranslations = Collections.synchronizedMap(new TreeMap());
    private static final Pattern LANGUAGE_FILE_PATTERN = Pattern.compile("^[a-z][a-z0-9]+_[a-z0-9]{2,}$");
    private static final Codec<Map<String, String>> LANGUAGE_FILE_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
    private final CompletableFuture<class_7225.class_7874> registriesFuture;
    private final String languageCode;
    private final ContextAwarePackOutput output;

    public SparkweaveLanguageProvider(ContextAwarePackOutput output, CompletableFuture<class_7225.class_7874> registriesFuture, String languageCode) {
        Preconditions.checkArgument((boolean)LANGUAGE_FILE_PATTERN.asMatchPredicate().test(languageCode), (String)"Invalid language code: %s", (Object)languageCode);
        this.output = output;
        this.registriesFuture = registriesFuture;
        this.languageCode = languageCode;
    }

    public abstract void generateTranslations(class_7225.class_7874 var1, TranslationBuilder var2);

    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        return this.registriesFuture.thenCompose(registries -> {
            TranslationBuilder builder = new TranslationBuilder((class_7225.class_7874)registries);
            this.extraTranslations.forEach(builder::add);
            this.generateTranslations((class_7225.class_7874)registries, builder);
            class_7784.class_7489 pathProvider = this.output.method_45973(class_7784.class_7490.field_39368, "lang");
            Path outputPath = pathProvider.method_44107(class_2960.method_60655((String)this.output.getModContainer().metadata().id(), (String)this.languageCode));
            return class_2405.method_53496((class_7403)cachedOutput, (class_7225.class_7874)registries, LANGUAGE_FILE_CODEC, builder.build(), (Path)outputPath);
        });
    }

    public String method_10321() {
        return "Language Provider/%s/%s".formatted(this.output.getModContainer().metadata().displayName(), this.languageCode);
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public boolean isDefaultLanguage() {
        return this.languageCode.equals("en_us");
    }

    public void addExtra(String key, String translation) {
        if (!this.isDefaultLanguage()) {
            throw new IllegalStateException("Attempted to add auto translation to %s language provider, can only add translations to default (%s) language!".formatted(this.languageCode, "en_us"));
        }
        String prev = this.extraTranslations.putIfAbsent(key, translation);
        if (prev != null) {
            throw new IllegalArgumentException("Translation key '%s' was already translated!".formatted(key));
        }
    }
}

