/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.platform;

import java.util.TreeSet;
import java.util.regex.Pattern;
import net.minecraft.class_2960;

public class PlatformUtils {
    private static final Pattern FABRIC_MOD_ID_PATTERN = Pattern.compile("^[a-z][a-z0-9-_]{1,63}$");
    private static final Pattern NEOFORGE_MOD_ID_PATTERN = Pattern.compile("^[a-z][a-z0-9_]{1,63}$");

    public static boolean isValidModId(String modid) {
        if (!FABRIC_MOD_ID_PATTERN.asMatchPredicate().test(modid)) {
            return false;
        }
        if (!NEOFORGE_MOD_ID_PATTERN.asMatchPredicate().test(modid)) {
            return false;
        }
        return class_2960.method_20209((String)modid);
    }

    public static void assertValidModId(String modid) {
        boolean validVanilla = class_2960.method_20209((String)modid);
        boolean validFabric = FABRIC_MOD_ID_PATTERN.asMatchPredicate().test(modid);
        boolean validNeoForge = NEOFORGE_MOD_ID_PATTERN.asMatchPredicate().test(modid);
        if (!(validVanilla && validFabric && validNeoForge)) {
            TreeSet<String> failed = new TreeSet<String>();
            if (!validVanilla) {
                failed.add("Vanilla");
            }
            if (!validFabric) {
                failed.add("Fabric");
            }
            if (!validNeoForge) {
                failed.add("NeoForge");
            }
            throw new AssertionError((Object)"Mod ID '%s' is invalid for the following platforms: %s".formatted(modid, String.join((CharSequence)", ", failed)));
        }
    }
}

