/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.upcraft.sparkweave.api.command.CommandHelper;
import dev.upcraft.sparkweave.api.command.argument.RegistryArgumentType;
import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.Services;
import dev.upcraft.sparkweave.api.serialization.CSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.apache.logging.log4j.Logger;

public class DumpRegistryCommand {
    private static final Logger LOGGER = SparkweaveLoggerFactory.getLogger();

    public static void register(LiteralArgumentBuilder<class_2168> $) {
        $.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump_registries").requires(src -> src.method_9259(4))).executes(DumpRegistryCommand::dumpAllRegistries)).then(class_2170.method_9244((String)"registry", (ArgumentType)RegistryArgumentType.registry()).executes(ctx -> DumpRegistryCommand.dumpRegistry((CommandContext<class_2168>)ctx, RegistryArgumentType.getRegistry((CommandContext<class_2168>)ctx, "registry"))))).then(class_2170.method_9247((String)"all").executes(DumpRegistryCommand::dumpAllRegistries)));
    }

    private static int dumpAllRegistries(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_5455.class_6890 registryAccess = ((class_2168)ctx.getSource()).method_9211().method_46221().method_45926();
        List registries = registryAccess.method_55282().toList();
        Path dir = Services.PLATFORM.getGameDir().resolve("sparkweave").resolve("registry_export");
        for (class_5321 registryKey : registries) {
            class_2378 registry = (class_2378)registryAccess.method_33310(registryKey).orElseThrow();
            DumpRegistryCommand.saveRegistryToFile(registry, dir);
        }
        if (((class_2168)ctx.getSource()).method_9211().method_19466(player.method_7334())) {
            class_5250 path = class_2561.method_43470((String)dir.toString()).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1078, class_124.field_1073}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.sparkweave.open_folder"))).method_10958(new class_2558(class_2558.class_2559.field_11746, dir.toString())));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_registries.multi_success_path", (Object[])new Object[]{registries.size(), path}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_registries.multi_success", (Object[])new Object[]{registries.size()}), true);
        }
        return registries.size();
    }

    private static int dumpRegistry(CommandContext<class_2168> ctx, class_2378<?> registry) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Path dir = Services.PLATFORM.getGameDir().resolve("sparkweave").resolve("registry_export");
        DumpRegistryCommand.saveRegistryToFile(registry, dir);
        if (((class_2168)ctx.getSource()).method_9211().method_19466(player.method_7334())) {
            class_5250 path = class_2561.method_43470((String)dir.toString()).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1078, class_124.field_1073}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.sparkweave.open_folder"))).method_10958(new class_2558(class_2558.class_2559.field_11746, dir.toString())));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_registries.success_path", (Object[])new Object[]{registry.method_30517().method_29177(), path}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_registries.success", (Object[])new Object[]{registry.method_30517().method_29177()}), true);
        }
        return 1;
    }

    private static void saveRegistryToFile(class_2378<?> registry, Path outputDir) throws CommandSyntaxException {
        Path outputFile = outputDir.resolve(registry.method_30517().method_29177().method_12836()).resolve(registry.method_30517().method_29177().method_12832() + ".csv");
        try {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            try (OutputStream stream = Files.newOutputStream(outputFile, new OpenOption[0]);
                 CSVWriter writer = CSVWriter.create(stream, "namespace", "path");){
                registry.method_10235().stream().sorted().forEachOrdered(key -> writer.addRow(key.method_12836(), key.method_12832()));
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to write registry dump for {}", (Object)registry.method_30517().method_29177(), (Object)e);
            throw CommandHelper.IO_EXCEPTION.create((Object)e.getMessage());
        }
    }
}

