/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.datagen;

import dev.upcraft.sparkweave.api.datagen.DynamicRegistryBuilder;
import dev.upcraft.sparkweave.api.datagen.provider.SparkweaveDynamicRegistryEntryProvider;
import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_7877;
import org.apache.logging.log4j.Logger;

public class DynamicRegistryBuilderImpl
implements DynamicRegistryBuilder {
    private static final Logger LOGGER = SparkweaveLoggerFactory.getLogger();
    private final List<SparkweaveDynamicRegistryEntryProvider> providers = new ArrayList<SparkweaveDynamicRegistryEntryProvider>();
    private final ModContainer modContainer;
    private final class_7877 registrySetBuilder;

    public DynamicRegistryBuilderImpl(ModContainer modContainer, class_7877 registrySetBuilder) {
        this.modContainer = modContainer;
        this.registrySetBuilder = registrySetBuilder;
    }

    @Override
    public DynamicRegistryBuilder add(Supplier<SparkweaveDynamicRegistryEntryProvider> factory) {
        SparkweaveDynamicRegistryEntryProvider provider = factory.get();
        LOGGER.info("Collecting entries: {}/{}", (Object)this.modContainer.metadata().displayName(), (Object)provider.getName());
        provider.generate(this.registrySetBuilder);
        this.providers.add(provider);
        return this;
    }

    public List<SparkweaveDynamicRegistryEntryProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }
}

