/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.fabric.impl.datagen;

import dev.upcraft.sparkweave.api.datagen.ContextAwarePackOutput;
import dev.upcraft.sparkweave.api.datagen.DataGenerationContext;
import dev.upcraft.sparkweave.api.datagen.Pack;
import dev.upcraft.sparkweave.api.datagen.provider.SparkweaveDynamicRegistryEntryProvider;
import dev.upcraft.sparkweave.api.datagen.provider.SparkweaveLanguageProvider;
import dev.upcraft.sparkweave.fabric.impl.datagen.FabricDataGenerationContext;
import dev.upcraft.sparkweave.fabric.mixin.datagen.PackGeneratorAccessor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2405;
import net.minecraft.class_7225;

public class FabricBuiltinPack
implements Pack {
    private final FabricDataGenerationContext context;
    private final FabricDataGenerator.Pack pack;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;
    private final List<SparkweaveDynamicRegistryEntryProvider> dynamicProviders;
    private final ContextAwarePackOutput output;
    private boolean hasTranslations;

    public FabricBuiltinPack(FabricDataGenerationContext context, FabricDataGenerator.Pack pack, CompletableFuture<class_7225.class_7874> registriesFuture, List<SparkweaveDynamicRegistryEntryProvider> dynamicProviders) {
        this.context = context;
        this.pack = pack;
        this.registriesFuture = registriesFuture;
        this.dynamicProviders = dynamicProviders;
        this.output = new ContextAwarePackOutput(((PackGeneratorAccessor)pack).sparkweave$getPackOutput().method_45971(), context.getMod());
    }

    @Override
    public <T extends class_2405> T addProvider(Predicate<DataGenerationContext> enabled, Function<ContextAwarePackOutput, T> factory) {
        SparkweaveLanguageProvider languageProvider;
        class_2405 provider = (class_2405)factory.apply(this.output);
        if (enabled.test(this.context)) {
            this.pack.addProvider(fabricOutput -> provider);
        }
        if (!this.hasTranslations && provider instanceof SparkweaveLanguageProvider && (languageProvider = (SparkweaveLanguageProvider)provider).isDefaultLanguage()) {
            this.dynamicProviders.forEach(it -> it.appendTranslations(languageProvider::addExtra));
            this.hasTranslations = true;
        }
        return (T)provider;
    }

    @Override
    public <T extends class_2405> T addProvider(Predicate<DataGenerationContext> enabled, Pack.RegistryDependentFactory<T> factory) {
        SparkweaveLanguageProvider languageProvider;
        Object provider = factory.create(this.output, this.registriesFuture);
        if (enabled.test(this.context)) {
            this.pack.addProvider((fabricOutput, registriesFuture1) -> provider);
        }
        if (!this.hasTranslations && provider instanceof SparkweaveLanguageProvider && (languageProvider = (SparkweaveLanguageProvider)provider).isDefaultLanguage()) {
            this.dynamicProviders.forEach(it -> it.appendTranslations(languageProvider::addExtra));
            this.hasTranslations = true;
        }
        return provider;
    }
}

