/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.fabric.impl.registry;

import com.google.common.base.Suppliers;
import dev.upcraft.sparkweave.api.registry.RegistryHandler;
import dev.upcraft.sparkweave.api.registry.RegistryHelper;
import dev.upcraft.sparkweave.api.registry.RegistrySupplier;
import dev.upcraft.sparkweave.fabric.impl.registry.FabricRegistrySupplier;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class FabricRegistryHandler<T>
implements RegistryHandler<T> {
    private final class_5321<class_2378<T>> registryKey;
    private final String namespace;
    private final Supplier<class_2378<T>> registry;
    private final Map<class_2960, RegistrySupplier<? extends T>> values = new Object2ObjectOpenHashMap();
    private final List<RegistrySupplier<? extends T>> orderedEntries = new LinkedList<RegistrySupplier<? extends T>>();

    private FabricRegistryHandler(class_5321<class_2378<T>> registryKey, String namespace) {
        this.registryKey = registryKey;
        this.namespace = namespace;
        this.registry = Suppliers.memoize(() -> RegistryHelper.getBuiltinRegistry(registryKey));
    }

    public static <T> FabricRegistryHandler<T> create(class_5321<class_2378<T>> registryKey, String modid) {
        return new FabricRegistryHandler<T>(registryKey, modid);
    }

    public <S extends T> FabricRegistrySupplier<T, S> register(String name, Supplier<S> factory) {
        class_5321 id = class_5321.method_29179(this.registryKey, (class_2960)class_2960.method_60655((String)this.namespace, (String)name));
        return this.register(id, (Supplier)factory);
    }

    public <S extends T> FabricRegistrySupplier<T, S> register(class_5321<T> id, Supplier<S> factory) {
        if (!this.namespace.equals(id.method_29177().method_12836())) {
            throw new IllegalArgumentException("Cannot register %s because namespace does not match the expected value %s".formatted(id, this.namespace));
        }
        FabricRegistrySupplier<T, T> supplier = new FabricRegistrySupplier<T, T>(id, factory);
        supplier.register(this.registry.get());
        this.values.put(id.method_29177(), supplier);
        this.orderedEntries.add(supplier);
        return supplier;
    }

    @Override
    public Map<class_2960, RegistrySupplier<? extends T>> values() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public List<RegistrySupplier<? extends T>> getEntriesOrdered() {
        return Collections.unmodifiableList(this.orderedEntries);
    }

    @Override
    public Stream<RegistrySupplier<? extends T>> stream() {
        return this.orderedEntries.stream();
    }

    @Override
    public class_5321<class_2378<T>> registry() {
        return this.registryKey;
    }

    @Override
    public class_2378<T> createNewRegistry(boolean sync, @Nullable class_2960 defaultEntry) {
        FabricRegistryBuilder builder;
        FabricRegistryBuilder fabricRegistryBuilder = builder = defaultEntry != null ? FabricRegistryBuilder.createDefaulted(this.registryKey, (class_2960)defaultEntry) : FabricRegistryBuilder.createSimple(this.registryKey);
        if (sync) {
            builder.attribute(RegistryAttribute.SYNCED);
        }
        return builder.buildAndRegister();
    }
}

