/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.delivery;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.delivery.SpellStash;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.StatusEffectUtil;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class SpellStashHelper {
    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(SpellStashHelper::link);
    }

    private static void link(MinecraftServer minecraftServer) {
        class_5455.class_6890 manager = minecraftServer.method_30611();
        class_2378 registry = manager.method_30530(SpellRegistry.KEY);
        registry.method_40270().forEach(entry -> {
            Spell spell = (Spell)entry.comp_349();
            class_2960 id = ((class_5321)entry.method_40230().get()).method_29177();
            if (spell.deliver.type == Spell.Delivery.Type.STASH_EFFECT) {
                if (spell.deliver.stash_effect == null) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect`!");
                    return;
                }
                Spell.Delivery.StashEffect stashEffect = spell.deliver.stash_effect;
                if (stashEffect.id == null || stashEffect.id.isEmpty()) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect.id`!");
                    return;
                }
                List<Spell.Trigger> trigger = stashEffect.triggers;
                if (trigger == null || trigger.isEmpty()) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect.trigger`!");
                    return;
                }
                class_2960 effectId = class_2960.method_60654((String)stashEffect.id);
                class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(effectId);
                if (statusEffect == null) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " found no status effect for `stash_effect.id`: " + stashEffect.id);
                    return;
                }
                List<SpellStash.Entry> stashes = SpellStash.getStashedSpells(statusEffect);
                for (SpellStash.Entry existingStash : stashes) {
                    if (!existingStash.spell().equals(entry)) continue;
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " already has a stash effect linked to " + stashEffect.id);
                    return;
                }
                SpellStash.configure(statusEffect, (class_6880<Spell>)entry, stashEffect.triggers, stashEffect.impact_mode, stashEffect.consume, stashEffect.consumed_next_tick, stashEffect.consume_any_stacks);
            }
        });
    }

    public static void useStashes(SpellTriggers.Event event) {
        class_1657 caster = event.player;
        class_1937 world = caster.method_37908();
        HashMap<class_1293, StatusEffectUtil.Diff> effectChanges = new HashMap<class_1293, StatusEffectUtil.Diff>();
        Map activeEffects = Map.copyOf(caster.method_6088());
        for (Map.Entry entry : activeEffects.entrySet()) {
            class_1291 effect = (class_1291)((class_6880)entry.getKey()).comp_349();
            class_1293 stack = (class_1293)entry.getValue();
            block5: for (SpellStash.Entry stash : ((SpellStash)effect).getStashedSpells()) {
                class_6880<Spell> spellEntry = stash.spell();
                for (Spell.Trigger trigger : stash.triggers()) {
                    if (spellEntry == null || trigger == null || !SpellTriggers.evaluateTrigger(spellEntry, trigger, event)) continue;
                    int consume = stash.consume();
                    int stacksAvailable = effectChanges.getOrDefault(stack, new StatusEffectUtil.Diff(stack, stack.method_5578(), stash.delayConsume() ? 1 : 0)).newAmplifier();
                    if (!stash.consume_any_stacks() && stacksAvailable + 1 < consume) continue;
                    switch (stash.impactMode()) {
                        case PERFORM: {
                            class_1297 target = event.target(trigger);
                            class_1297 aoeSource = event.aoeSource(trigger);
                            Spell spell = (Spell)stash.spell().comp_349();
                            SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)event.player);
                            SpellHelper.ImpactContext impactContext = new SpellHelper.ImpactContext(1.0f, 1.0f, null, power, SpellTarget.FocusMode.DIRECT, 0);
                            impactContext = target != null ? impactContext.position(target.method_19538()) : (aoeSource != null ? impactContext.position(aoeSource.method_19538()) : impactContext.position(caster.method_19538()));
                            SpellHelper.performImpacts(world, (class_1309)caster, target, aoeSource, spellEntry, ((Spell)spellEntry.comp_349()).impacts, impactContext);
                            break;
                        }
                        case TRANSFER: {
                            ArrowExtension arrow = event.arrow;
                            if (arrow == null) break;
                            class_1657 shooter = event.player;
                            Supplier trackers = Suppliers.memoize(() -> PlayerLookup.tracking((class_1297)shooter));
                            ArrowHelper.onArrowShot(arrow, (class_1309)shooter, spellEntry, (java.util.function.Supplier<Collection<class_3222>>)trackers);
                        }
                    }
                    if (consume == 0) continue block5;
                    effectChanges.put(stack, new StatusEffectUtil.Diff(stack, stacksAvailable - consume, stash.delayConsume() ? 1 : 0));
                    continue block5;
                }
            }
        }
        List<StatusEffectUtil.Diff> changes = effectChanges.values().stream().toList();
        StatusEffectUtil.applyChanges((class_1309)caster, changes);
    }
}

