/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell.container;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_power.api.SpellSchool;

public class SpellContainerHelper {
    public static final Comparator<Map.Entry<class_2960, Spell>> spellSorter = (spell1, spell2) -> {
        if (((Spell)spell1.getValue()).tier > ((Spell)spell2.getValue()).tier) {
            return 1;
        }
        if (((Spell)spell1.getValue()).tier < ((Spell)spell2.getValue()).tier) {
            return -1;
        }
        return ((class_2960)spell1.getKey()).toString().compareTo(((class_2960)spell2.getKey()).toString());
    };

    public static SpellContainer createForRangedWeapon() {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.ARCHERY, List.of());
    }

    public static SpellContainer createForRangedWeapon(class_2960 spellId) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.ARCHERY, List.of(spellId));
    }

    public static SpellContainer createForRangedWeapon(List<class_2960> spellIds) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.ARCHERY, spellIds);
    }

    public static SpellContainer createForMagicWeapon() {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of());
    }

    public static SpellContainer createForMagicWeapon(class_2960 spellId) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of(spellId));
    }

    public static SpellContainer createForMeleeWeapon() {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of());
    }

    public static SpellContainer createForMeleeWeapon(class_2960 spellId) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of(spellId));
    }

    public static SpellContainer createForWeapon(SpellContainer.ContentType contentType, List<class_2960> spellIds) {
        List<String> spellIdStrings = spellIds.stream().map(class_2960::toString).toList();
        return new SpellContainer(contentType, true, "", 0, spellIdStrings);
    }

    public static SpellContainer createForShield(class_2960 spellId) {
        return SpellContainerHelper.createForShield(List.of(spellId));
    }

    public static SpellContainer createForShield(List<class_2960> spellIds) {
        return new SpellContainer(SpellContainer.ContentType.MAGIC, false, "", "offhand", 0, spellIds.stream().map(class_2960::toString).toList());
    }

    public static SpellContainer createForRelic(class_2960 spellId) {
        return new SpellContainer(SpellContainer.ContentType.ANY, false, "", 0, List.of(spellId.toString()));
    }

    public static SpellContainer createForSpellHost(class_2960 spellId) {
        return new SpellContainer(SpellContainer.ContentType.MAGIC, false, "", 0, List.of(spellId.toString()));
    }

    public static SpellContainer createForModifier(class_2960 spellId) {
        return new SpellContainer(SpellContainer.ContentType.ANY, false, "", 0, List.of(spellId.toString()));
    }

    public static SpellContainer containerFromItemStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return null;
        }
        SpellContainer component = (SpellContainer)itemStack.method_57824(SpellDataComponents.SPELL_CONTAINER);
        if (component != null) {
            return component;
        }
        class_2960 id = ((class_5321)itemStack.method_7909().method_40131().method_40230().get()).method_29177();
        return SpellAssignments.containerForItem(id);
    }

    public static class_2960 getPoolId(SpellContainer container) {
        if (container != null && container.pool() != null) {
            return class_2960.method_60654((String)container.pool());
        }
        return null;
    }

    public static boolean contains(SpellContainer container, class_2960 spellId) {
        return container != null && container.spell_ids().contains(spellId.toString());
    }

    public static List<String> sortedSpells(class_1937 world, List<String> spellIds) {
        HashMap<class_2960, Spell> spells = new HashMap<class_2960, Spell>();
        for (String idString : spellIds) {
            class_2960 id = class_2960.method_60654((String)idString);
            class_6880.class_6883 spellEntry = SpellRegistry.from(world).method_55841(id).orElse(null);
            if (spellEntry == null) continue;
            spells.put(id, (Spell)spellEntry.comp_349());
        }
        return spells.entrySet().stream().sorted(spellSorter).map(entry -> ((class_2960)entry.getKey()).toString()).collect(Collectors.toList());
    }

    public static SpellContainer addSpell(class_1937 world, class_2960 spellId, SpellContainer container) {
        ArrayList<String> spellIds = new ArrayList<String>(container.spell_ids());
        spellIds.add(spellId.toString());
        return container.copyWith(SpellContainerHelper.sortedSpells(world, spellIds));
    }

    public static void addSpell(class_1937 world, class_2960 spellId, class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null || !container.isValid()) {
            System.err.println("Trying to add spell: " + String.valueOf(spellId) + " to an ItemStack without valid spell container");
            return;
        }
        SpellContainer modifiedContainer = SpellContainerHelper.addSpell(world, spellId, container);
        itemStack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)modifiedContainer);
    }

    public static boolean hasValidContainer(class_1799 itemStack) {
        return SpellContainerHelper.containerFromItemStack(itemStack) != null;
    }

    public static boolean hasBindableContainer(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && container.pool() != null && !container.pool().isEmpty();
    }

    public static boolean hasUsableContainer(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && (container.isUsable() || container.is_proxy());
    }

    public static boolean isSpellValidForItem(class_1792 item, class_6880<Spell> spell) {
        SpellContainer.ContentType spellType = ((Spell)spell.comp_349()).school.archetype == SpellSchool.Archetype.ARCHERY ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
        SpellContainer.ContentType expectedContentType = item instanceof class_1811 ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
        return spellType == expectedContentType;
    }

    public static SpellContainer.ContentType contentTypeForItem(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return container.content();
        }
        class_1792 item = itemStack.method_7909();
        return item instanceof class_1811 ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
    }

    public static SpellContainer.ContentType contentTypeForSpell(Spell spell) {
        return spell.school.archetype == SpellSchool.Archetype.ARCHERY ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
    }

    public static SpellContainer create(class_6880<Spell> spell, class_1792 item) {
        return SpellContainerHelper.create(List.of(spell), item);
    }

    public static SpellContainer create(List<class_6880<Spell>> spells, class_1792 item) {
        SpellContainer.ContentType contentType = SpellContainerHelper.contentTypeForSpell((Spell)spells.get(0).comp_349());
        boolean isProxy = !ISpellBookItem.isSpellBook(item) && !item.method_40131().method_40220(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
        List<String> spellIds = spells.stream().filter(entry -> SpellContainerHelper.contentTypeForSpell((Spell)entry.comp_349()) == contentType).map(entry -> ((class_5321)entry.method_40230().get()).method_29177().toString()).toList();
        return new SpellContainer(contentType, isProxy, "", spellIds.size(), spellIds);
    }
}

