/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.spell_engine.api.spell.Spell;
import org.jetbrains.annotations.Nullable;

public class SpellRegistry {
    public static final class_2960 ID = class_2960.method_60656((String)"spell");
    public static final class_5321<class_2378<Spell>> KEY = class_5321.method_29180((class_2960)ID);
    private static final Gson gson = new GsonBuilder().create();
    public static final Codec<Spell> LOCAL_CODEC = class_5699.field_40721.xmap(json -> (Spell)gson.fromJson(json, Spell.class), spell -> {
        JsonElement jsonElement = gson.toJsonTree(spell);
        return jsonElement;
    });
    public static final Codec<Spell> NETWORK_CODEC_V2 = Codec.BYTE_BUFFER.comapFlatMap(encoded -> {
        byte[] bytes = encoded.array();
        String json = new String(bytes);
        Spell spell = (Spell)gson.fromJson(json, Spell.class);
        return DataResult.success((Object)spell);
    }, spell -> {
        String json = gson.toJson(spell);
        byte[] bytes = json.getBytes();
        return ByteBuffer.wrap(bytes);
    });
    public static final Codec<Spell> NETWORK_CODEC = Codec.STRING.comapFlatMap(encoded -> {
        byte[] bytes = encoded.getBytes();
        String json = new String(Base64.getDecoder().decode(bytes));
        Spell spell = (Spell)gson.fromJson(json, Spell.class);
        return DataResult.success((Object)spell);
    }, spell -> {
        String json = gson.toJson(spell);
        byte[] bytes = json.getBytes();
        return Base64.getEncoder().encodeToString(bytes);
    });

    public static class_2378<Spell> from(class_1937 world) {
        return world.method_30349().method_30530(KEY);
    }

    public static class_6885.class_6888<Spell> find(class_1937 world, class_2960 tagId) {
        class_5455 manager = world.method_30349();
        class_7871 lookup = manager.method_46758().method_46751(KEY);
        class_6862 tag = class_6862.method_40092(KEY, (class_2960)tagId);
        return lookup.method_46735(tag);
    }

    public static List<class_6880<Spell>> entries(class_1937 world, @Nullable class_2960 id) {
        try {
            return SpellRegistry.find(world, id).method_40239().toList();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static List<class_6880<Spell>> entries(class_1937 world, @Nullable String pool) {
        if (pool == null || pool.isEmpty()) {
            return List.of();
        }
        class_2960 id = class_2960.method_60654((String)pool);
        return SpellRegistry.entries(world, id);
    }

    public static Stream<class_6880.class_6883<Spell>> stream(class_1937 world) {
        class_5455 manager = world.method_30349();
        class_2378 registry = manager.method_30530(KEY);
        return registry.method_40270();
    }
}

