/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.accessories;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.compat.accessories.AccessoriesItemHelper;
import net.spell_engine.compat.container.ContainerCompat;
import net.spell_engine.internals.container.SpellContainerSource;

public class AccessoriesCompat {
    private static final String MOD_ID = "accessories";
    private static final String SLOT_SPELL_BOOK = "spell_book";
    private static boolean intialized = false;
    private static boolean enabled = false;

    public static boolean init() {
        if (intialized) {
            return enabled;
        }
        intialized = true;
        enabled = FabricLoader.getInstance().isModLoaded(MOD_ID);
        if (!enabled) {
            return enabled;
        }
        AccessoriesAPI.registerPredicate((class_2960)class_2960.method_60655((String)"spell_engine", (String)SLOT_SPELL_BOOK), (world, slotType, i, itemStack) -> {
            if (ISpellBookItem.isSpellBook(itemStack.method_7909())) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        ContainerCompat.addProvider(AccessoriesCompat::getAll);
        String spellSourceName = MOD_ID;
        SpellContainerSource.addItemSource(SpellContainerSource.ItemEntry.of(MOD_ID, (player, name) -> AccessoriesCompat.getEquippedStacks(player)), SpellContainerSource.MAIN_HAND.name());
        AccessoryChangeCallback.EVENT.register((prevStack, currentStack, slotReference, stateChange) -> {
            class_1309 patt0$temp = slotReference.entity();
            if (patt0$temp instanceof class_1657) {
                class_1657 player = (class_1657)patt0$temp;
                SpellContainerSource.setDirty(player, MOD_ID);
            }
        });
        AccessoriesItemHelper.register();
        return enabled;
    }

    private static List<class_1799> getAll(class_1657 player) {
        Optional capability = AccessoriesCapability.getOptionally((class_1309)player);
        if (capability.isEmpty()) {
            return List.of();
        }
        ArrayList<class_1799> accessories = new ArrayList<class_1799>();
        AccessoriesCapability accessoriesContainer = (AccessoriesCapability)capability.get();
        accessoriesContainer.getContainers().forEach((slotType, container) -> {
            ExpandedSimpleContainer accessoriesInv = container.getAccessories();
            for (int i = 0; i < accessoriesInv.method_5439(); ++i) {
                class_1799 stack = accessoriesInv.method_5438(i);
                if (stack.method_7960()) continue;
                accessories.add(stack);
            }
        });
        return accessories;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<SpellContainerSource.SourcedContainer> getSpellContainers(class_1657 player, String sourceName) {
        Optional capability = AccessoriesCapability.getOptionally((class_1309)player);
        if (capability.isEmpty()) {
            return List.of();
        }
        ArrayList<SpellContainerSource.SourcedContainer> spellBooks = new ArrayList<SpellContainerSource.SourcedContainer>();
        ArrayList others = new ArrayList();
        AccessoriesCapability accessoriesContainer = (AccessoriesCapability)capability.get();
        accessoriesContainer.getContainers().forEach((slotType, container) -> {
            ExpandedSimpleContainer accessoriesInv = container.getAccessories();
            for (int i = 0; i < accessoriesInv.method_5439(); ++i) {
                SpellContainer spellContainer;
                class_1799 stack = accessoriesInv.method_5438(i);
                if (stack.method_7960() || (spellContainer = SpellContainerHelper.containerFromItemStack(stack)) == null || !spellContainer.isValid()) continue;
                if (slotType.contains(SLOT_SPELL_BOOK)) {
                    spellBooks.add(new SpellContainerSource.SourcedContainer(sourceName, stack, spellContainer));
                    continue;
                }
                others.add(new SpellContainerSource.SourcedContainer(sourceName, stack, spellContainer));
            }
        });
        spellBooks.addAll(others);
        return spellBooks;
    }

    public static List<class_1799> getEquippedStacks(class_1657 player) {
        Optional capability = AccessoriesCapability.getOptionally((class_1309)player);
        if (capability.isEmpty()) {
            return List.of();
        }
        ArrayList<class_1799> equipped = new ArrayList<class_1799>();
        AccessoriesCapability accessoriesContainer = (AccessoriesCapability)capability.get();
        accessoriesContainer.getContainers().forEach((slotType, container) -> {
            ExpandedSimpleContainer accessoriesInv = container.getAccessories();
            for (int i = 0; i < accessoriesInv.method_5439(); ++i) {
                class_1799 stack = accessoriesInv.method_5438(i);
                if (stack.method_7960()) continue;
                if (slotType.contains(SLOT_SPELL_BOOK)) {
                    equipped.addFirst(stack);
                    continue;
                }
                equipped.add(stack);
            }
        });
        return equipped;
    }

    public static class_1799 getSpellBookStack(class_1657 player) {
        ExpandedSimpleContainer accessoriesInv;
        if (!enabled) {
            return class_1799.field_8037;
        }
        Optional capability = AccessoriesCapability.getOptionally((class_1309)player);
        if (capability.isEmpty()) {
            return class_1799.field_8037;
        }
        AccessoriesContainer container = (AccessoriesContainer)((AccessoriesCapability)capability.get()).getContainers().get(SLOT_SPELL_BOOK);
        if (container != null && !(accessoriesInv = container.getAccessories()).method_5442()) {
            return accessoriesInv.method_5438(0);
        }
        return class_1799.field_8037;
    }
}

