/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.base;

import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;

public class ListWidget
extends ContainerWidget {
    private static final int SCROLLBAR_WIDTH = 2;
    private static final int SCROLLBAR_PADDING = 4;
    private static final int OVERSCROLL = 2;
    protected final List<Item> items = new ArrayList<Item>();
    private double scroll = 0.0;
    private int lastHeight = 0;
    private boolean scrolling = false;

    public ListWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void update(ListWidget old) {
        if (this.items.size() != old.items.size()) {
            return;
        }
        if (this.field_22759 != old.field_22759) {
            return;
        }
        this.updateLastHeight();
        if (this.lastHeight != old.lastHeight) {
            return;
        }
        this.scroll = old.scroll;
        this.scrolling = old.scrolling;
    }

    public void add(Item item) {
        this.items.add(item);
        this.updateScrollBar();
    }

    @Override
    public void clear() {
        super.clear();
        this.items.clear();
    }

    @Override
    @NotNull
    public List<? extends class_364> method_25396() {
        return this.items;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        boolean showsScrollBar = this.lastHeight > this.field_22759;
        int actualWidth = this.method_25368() - (showsScrollBar ? 6 : 0);
        graphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + actualWidth, this.method_46427() + this.field_22759);
        int y = this.method_46427() - (int)this.scroll + 1;
        this.lastHeight = 0;
        for (Item item : this.items) {
            item.setItemWidth(actualWidth);
            item.method_46421(this.method_46426());
            item.method_46419(y);
            item.method_25394(graphics, mouseX, mouseY, partialTicks);
            y += item.method_25364();
            this.lastHeight += item.method_25364();
        }
        graphics.method_44380();
        if (this.lastHeight > this.field_22759) {
            int scrollBarHeight = (int)((double)this.field_22759 / (double)this.lastHeight * (double)this.field_22759) - 8;
            int scrollBarX = this.method_46426() + this.field_22758 - 2 - 1;
            int scrollBarY = this.method_46427() + 4 + (int)(this.scroll / (double)this.lastHeight * (double)this.field_22759);
            int scrollBarColor = this.method_25405(mouseX, mouseY) && mouseX >= scrollBarX && mouseX <= scrollBarX + 2 && mouseY >= scrollBarY && mouseY <= scrollBarY + scrollBarHeight ? -986896 : -4144960;
            graphics.method_25294(scrollBarX, scrollBarY, scrollBarX + 2, scrollBarY + scrollBarHeight, scrollBarColor);
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            double scrollBarHeight = (double)this.field_22759 / (double)this.lastHeight * (double)this.field_22759;
            double scrollBarDragY = dragY / ((double)this.field_22759 - scrollBarHeight);
            this.scroll = class_3532.method_15350((double)(this.scroll + scrollBarDragY * (double)this.lastHeight), (double)0.0, (double)Math.max(0, this.lastHeight - this.field_22759 + 2));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scroll = class_3532.method_15350((double)(this.scroll - scrollY * 10.0), (double)0.0, (double)Math.max(0, this.lastHeight - this.field_22759 + 2));
        return true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            if (this.isMouseOverScrollBar(mouseX, mouseY)) {
                this.scrolling = true;
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean method_25406(double d, double e, int i) {
        if (i == 0) {
            this.scrolling = false;
        }
        return super.method_25406(d, e, i);
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        if (this.lastHeight > this.field_22759) {
            int scrollBarX = this.method_46426() + this.field_22758 - 2 - 1;
            return mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 2) && mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.field_22759);
        }
        return false;
    }

    protected void updateLastHeight() {
        boolean showsScrollBar = this.lastHeight > this.field_22759;
        int actualWidth = this.method_25368() - (showsScrollBar ? 6 : 0);
        this.lastHeight = 0;
        int y = this.method_46427() - (int)this.scroll + 1;
        for (Item item : this.items) {
            item.setItemWidth(actualWidth);
            item.method_46421(this.method_46426());
            item.method_46419(y);
            this.lastHeight += item.method_25364();
            y += item.method_25364();
        }
    }

    protected void updateScrollBar() {
        this.updateLastHeight();
        this.scroll = class_3532.method_15350((double)this.scroll, (double)0.0, (double)Math.max(0, this.lastHeight - this.field_22759 + 2));
    }

    public static interface Item
    extends class_364,
    class_4068,
    class_6379,
    class_8021 {
        @NotNull
        default public class_8030 method_48202() {
            return super.method_48202();
        }

        public void setItemWidth(int var1);
    }
}

