/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DropdownWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.AlphaSelector;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.EyedropperButton;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbColor;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbState;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HueSelector;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.PresetsSelector;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.RecentColorStorage;
import com.teamresourceful.resourcefulconfig.client.components.options.types.color.SaturationBrightnessSelector;
import com.teamresourceful.resourcefulconfig.client.screens.base.CloseableScreen;
import com.teamresourceful.resourcefulconfig.client.screens.base.OverlayScreen;
import com.teamresourceful.resourcefulconfig.client.utils.State;
import java.util.Locale;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public class ColorOptionWidget
extends BaseWidget {
    private static final int SIZE = 16;
    private static final int PADDING = 4;
    private static final int SPACING = 2;
    private final int[] presets;
    private final boolean hasAlpha;
    private final IntSupplier getter;
    private final IntConsumer setter;

    public ColorOptionWidget(int[] presets, boolean hasAlpha, IntSupplier getter, IntConsumer setter) {
        super(16, 16);
        this.presets = presets;
        this.hasAlpha = hasAlpha;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_52706(ModSprites.BUTTON, this.method_46426(), this.method_46427(), this.field_22759, this.field_22759);
        graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.field_22759 - 1, this.method_46427() + this.field_22759 - 1, this.getter.getAsInt());
    }

    public void method_25348(double d, double e) {
        class_310.method_1551().method_1507((class_437)new PresetsOverlay(this));
    }

    private static class PresetsOverlay
    extends OverlayScreen
    implements CloseableScreen {
        private final ColorOptionWidget widget;
        private final HsbState state;
        private final State<PresetType> type;
        private int x;
        private int y;
        private int width;
        private int height;

        protected PresetsOverlay(ColorOptionWidget widget) {
            super(class_310.method_1551().field_1755);
            this.widget = widget;
            this.state = new HsbState(HsbColor.fromRgb(widget.getter.getAsInt()), color -> widget.setter.accept(color.toRgba()));
            this.type = State.of(widget.presets.length == 0 ? (RecentColorStorage.hasValues() ? PresetType.RECENTS : PresetType.MC_COLORS) : PresetType.DEFAULTS);
        }

        @Override
        protected void method_25426() {
            class_7845 layout = new class_7845().method_48637(2);
            layout.method_46452((class_8021)new SaturationBrightnessSelector(100, 50, this.state), 0, 0);
            layout.method_46452((class_8021)new HueSelector(100, 10, this.state), 1, 0);
            if (this.widget.hasAlpha) {
                layout.method_46452((class_8021)new AlphaSelector(100, 10, this.state), 2, 0);
            }
            class_8667 presets = class_8667.method_52742().method_52735(4);
            presets.method_52736((class_8021)new EyedropperButton(this.state));
            presets.method_52736((class_8021)DropdownWidget.of((Enum[])(this.widget.presets.length == 0 ? PresetType.WITHOUT_DEFAULT : PresetType.VALUES), this.type, this.type));
            layout.method_46452((class_8021)presets, 3, 0);
            layout.method_46452((class_8021)new PresetsSelector(100, this.widget.presets, this.type, this.state, this.widget.hasAlpha), 4, 0);
            layout.method_48222();
            int windowHeight = this.method_48202().comp_1197();
            int y = this.widget.method_46427() + this.widget.method_25364() + 2 + layout.method_25364() + 8 > windowHeight ? this.widget.method_46427() - layout.method_25364() - 8 - 2 : this.widget.method_46427() + this.widget.method_25364() + 2;
            layout.method_48229(this.widget.method_46426() + 4, y + 4);
            layout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.x = this.widget.method_46426();
            this.y = y;
            this.width = layout.method_25368() + 8;
            this.height = layout.method_25364() + 8;
        }

        @Override
        public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_25420(graphics, mouseX, mouseY, partialTicks);
            graphics.method_52706(ModSprites.ACCENT, this.x, this.y, this.width, this.height);
            graphics.method_52706(ModSprites.BUTTON, this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        }

        @Override
        public void onClosed(@Nullable class_437 replacement) {
            if (replacement instanceof OverlayScreen) {
                return;
            }
            if (!this.state.hasChanged()) {
                return;
            }
            RecentColorStorage.add(this.state.get());
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button != 0 || this.method_25405(mouseX, mouseY)) {
                return super.method_25402(mouseX, mouseY, button);
            }
            this.method_25419();
            return false;
        }
    }

    public static enum PresetType implements Translatable
    {
        RECENTS,
        DEFAULTS,
        MC_COLORS;

        private static final PresetType[] VALUES;
        private static final PresetType[] WITHOUT_DEFAULT;

        @Override
        public String getTranslationKey() {
            return "rconfig.color.preset." + this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = PresetType.values();
            WITHOUT_DEFAULT = new PresetType[]{RECENTS, MC_COLORS};
        }
    }
}

