/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.OverlayScreen;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class DropdownWidget
extends BaseWidget {
    private static final int WIDTH = 80;
    private final Enum<?>[] options;
    private final Supplier<Enum<?>> getter;
    private final Consumer<Enum<?>> setter;
    private class_2561 title = class_2561.method_43473();

    public DropdownWidget(int width, Enum<?>[] options, Supplier<Enum<?>> getter, Consumer<Enum<?>> setter) {
        super(width, 16);
        this.options = options;
        this.getter = getter;
        this.setter = setter;
    }

    public DropdownWidget(Enum<?>[] options, Supplier<Enum<?>> getter, Consumer<Enum<?>> setter) {
        this(80, options, getter, setter);
    }

    public static <T extends Enum<?>> DropdownWidget of(T[] options, Supplier<T> getter, Consumer<T> setter) {
        return new DropdownWidget((Enum<?>[])options, getter::get, t -> setter.accept(t));
    }

    public DropdownWidget setTitle(class_2561 title) {
        this.title = title;
        return this;
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_52706(ModSprites.ofButton(this.method_49606()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        DropdownWidget.method_52718((class_332)graphics, (class_327)this.font, (class_2561)Translatable.toComponent(this.getter.get(), this.title), (int)(this.method_46426() + 4), (int)(this.method_46427() + 4), (int)(this.method_46426() + this.method_25368() - 16), (int)(this.method_46427() + this.method_25364() - 4), (int)-9276296);
        graphics.method_52706(ModSprites.CHEVRON_DOWN, this.method_46426() + this.method_25368() - 12, this.method_46427() + 4, 8, 8);
    }

    public void method_25348(double d, double e) {
        class_310.method_1551().method_1507((class_437)new DropdownOverlay(this));
    }

    private static class DropdownOverlay
    extends OverlayScreen {
        private final DropdownWidget widget;

        protected DropdownOverlay(DropdownWidget widget) {
            super(class_310.method_1551().field_1755);
            this.widget = widget;
        }

        @Override
        protected void method_25426() {
            DropdownList list = (DropdownList)this.method_37063((class_364)DropdownList.of(this.widget));
            for (Enum<?> option : this.widget.options) {
                list.add(new DropdownItem(option, value -> {
                    this.widget.setter.accept((Enum<?>)value);
                    this.method_25419();
                }));
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_19355(mouseX, mouseY).isEmpty()) {
                this.method_25419();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    private static class DropdownItem
    extends BaseWidget
    implements ListWidget.Item {
        private final Enum<?> option;
        private final Consumer<Enum<?>> setter;

        public DropdownItem(Enum<?> option, Consumer<Enum<?>> setter) {
            super(80, 12);
            this.option = option;
            this.setter = setter;
        }

        @Override
        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.method_52706(ModSprites.ofButton(this.method_49606()), this.method_46426() + 1, this.method_46427(), this.method_25368() - 1, this.method_25364());
            int color = this.method_49606() ? -329226 : -9276296;
            DropdownItem.method_52718((class_332)graphics, (class_327)this.font, (class_2561)Translatable.toComponent(this.option), (int)(this.method_46426() + 4), (int)(this.method_46427() + 1), (int)(this.method_46426() + this.method_25368() - 4), (int)(this.method_46427() + this.method_25364() - 1), (int)color);
        }

        public void method_25348(double mouseX, double e) {
            this.setter.accept(this.option);
        }

        @Override
        public void setItemWidth(int width) {
            this.method_25358(width);
        }
    }

    private static class DropdownList
    extends ListWidget {
        public DropdownList(int x, int y, int height) {
            super(x + 1, y, 78, height);
        }

        public static DropdownList of(DropdownWidget widget) {
            int listHeight;
            int windowHeight = class_310.method_1551().method_22683().method_4502();
            int widgetY = widget.method_46427() + widget.method_25364();
            if (widgetY + (listHeight = Math.min(widget.options.length * 12, 96) + 1) > windowHeight) {
                widgetY = widget.method_46427() - listHeight - 1;
            }
            return new DropdownList(widget.method_46426(), widgetY, listHeight);
        }

        @Override
        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.method_52706(ModSprites.ACCENT, this.method_46426() - 1, this.method_46427() - 1, this.method_25368() + 2, this.method_25364() + 2);
            graphics.method_52706(ModSprites.BUTTON, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            super.method_48579(graphics, mouseX, mouseY, partialTicks);
        }
    }
}

