/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.requirement.RequirementFunction;
import net.blay09.mods.waystones.api.requirement.VariableResolver;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.api.requirement.WarpRequirementsContext;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.requirement.CombinedRequirement;
import net.blay09.mods.waystones.requirement.ConfiguredCondition;
import net.blay09.mods.waystones.requirement.ConfiguredRequirement;
import net.blay09.mods.waystones.requirement.ConfiguredRequirementModifier;
import net.blay09.mods.waystones.requirement.NoRequirement;
import net.blay09.mods.waystones.requirement.RequirementRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class WarpRequirementsContextImpl
implements WarpRequirementsContext {
    private final Map<class_2960, WarpRequirement> requirements = new HashMap<class_2960, WarpRequirement>();
    private final WaystoneTeleportContext context;

    public WarpRequirementsContextImpl(WaystoneTeleportContext context) {
        this.context = context;
    }

    public <T extends WarpRequirement, P> void apply(ConfiguredRequirementModifier<T, P> configuredModifier) {
        for (ConfiguredCondition<?> condition : configuredModifier.conditions()) {
            if (this.matchesCondition(condition)) continue;
            return;
        }
        ConfiguredRequirement<T, P> requirement = configuredModifier.requirement();
        RequirementFunction<T, P> modifier = requirement.modifier();
        P parameters = requirement.parameters();
        WarpRequirement existing = this.requirements.get(modifier.getRequirementType());
        if (existing == null) {
            existing = RequirementRegistry.getRequirementType(modifier.getRequirementType()).createInstance();
        }
        this.requirements.put(modifier.getRequirementType(), modifier.apply(existing, this, parameters));
    }

    @Override
    public float getContextValue(class_2960 id) {
        VariableResolver resolver = RequirementRegistry.getVariableResolver(id);
        if (resolver != null) {
            return resolver.resolve(this.context);
        }
        class_1297 class_12972 = this.context.getEntity();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return (float)PlayerWaystoneManager.getCooldownMillisLeft(player, id) / 1000.0f;
        }
        return 0.0f;
    }

    @Override
    public <P> boolean matchesCondition(ConfiguredCondition<P> configuredCondition) {
        return configuredCondition.resolver().matches(this.context, configuredCondition.parameters());
    }

    public WarpRequirement resolve() {
        if (this.requirements.isEmpty()) {
            return NoRequirement.INSTANCE;
        }
        if (this.requirements.size() == 1) {
            return this.requirements.values().iterator().next();
        }
        return new CombinedRequirement(this.requirements.values());
    }
}

