/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.tree.CommandNode;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.calio.util.IdentifierAlias;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.command.OriginCommand;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.condition.factory.entity.OriginsEntityConditionTypes;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.networking.ModPacketsC2S;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.power.type.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModDataComponentTypes;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.registry.ModLoot;
import io.github.apace100.origins.registry.ModTags;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.apace100.origins.util.OriginLootCondition;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import io.github.apace100.origins.util.OriginsJsonConfigSerializer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Origins
implements ModInitializer {
    public static final String MODID = "origins";
    public static final Logger LOGGER = LogManager.getLogger(Origins.class);
    public static String VERSION = "";
    public static int[] SEMVER;
    public static ServerConfig config;
    private static ConfigSerializer<ServerConfig> configSerializer;

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            VERSION = modContainer.getMetadata().getVersion().getFriendlyString();
            if (VERSION.contains("+")) {
                VERSION = VERSION.split("\\+")[0];
            }
            if (VERSION.contains("-")) {
                VERSION = VERSION.split("-")[0];
            }
            String[] splitVersion = VERSION.split("\\.");
            SEMVER = new int[splitVersion.length];
            for (int i = 0; i < SEMVER.length; ++i) {
                Origins.SEMVER[i] = Integer.parseInt(splitVersion[i]);
            }
        });
        LOGGER.info("Origins " + VERSION + " is initializing. Have fun!");
        AutoConfig.register(ServerConfig.class, (definition, configClass) -> {
            configSerializer = new OriginsJsonConfigSerializer(definition, configClass, new OriginsConfigSerializer(definition, configClass));
            return configSerializer;
        });
        config = (ServerConfig)AutoConfig.getConfigHolder(ServerConfig.class).getConfig();
        IdentifierAlias.GLOBAL.addNamespaceAlias(MODID, "apoli");
        OriginsPowerTypes.register();
        OriginsEntityConditionTypes.register();
        ModBlocks.register();
        ModItems.register();
        ModTags.register();
        ModPackets.register();
        ModPacketsC2S.register();
        ModEntities.register();
        ModLoot.registerLootTables();
        ModComponents.register();
        ModDataComponentTypes.register();
        Origin.init();
        BadgeManager.init();
        OriginManager originManager = new OriginManager();
        OriginLayerManager originLayerManager = new OriginLayerManager();
        IdentifiableResourceReloadListener badgeManager = BadgeManager.REGISTRY.getLoader();
        PowerManager.DEPENDENCIES.add(badgeManager.getFabricId());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)originManager);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)originLayerManager);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(badgeManager);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> OriginCommand.register((CommandNode<class_2168>)dispatcher.getRoot()));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> content.method_45421((class_1935)ModItems.ORB_OF_ORIGIN));
        class_174.method_767((String)ChoseOriginCriterion.ID.toString(), (class_179)ChoseOriginCriterion.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41135, (class_2960)Origins.identifier("origin"), (Object)OriginLootCondition.TYPE);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ((OriginComponent)ModComponents.ORIGIN.get((Object)handler.field_14140)).selectingOrigin(false));
    }

    public static void serializeConfig() {
        try {
            configSerializer.serialize((ConfigData)config);
        }
        catch (ConfigSerializer.SerializationException e) {
            LOGGER.error("Failed serialization of config file: " + e.getMessage());
        }
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    @Config(name="origins_server")
    public static class ServerConfig
    implements ConfigData {
        public boolean performVersionCheck = true;
        public JsonObject origins = new JsonObject();

        public boolean isOriginDisabled(class_2960 originId) {
            String idString = originId.toString();
            if (!this.origins.has(idString)) {
                return false;
            }
            JsonElement element = this.origins.get(idString);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                return !class_3518.method_15258((JsonObject)jsonObject, (String)"enabled", (boolean)true);
            }
            return false;
        }

        public boolean isPowerDisabled(class_2960 originId, class_2960 powerId) {
            String originIdString = originId.toString();
            if (!this.origins.has(originIdString)) {
                return false;
            }
            String powerIdString = powerId.toString();
            JsonElement element = this.origins.get(originIdString);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                return !class_3518.method_15258((JsonObject)jsonObject, (String)powerIdString, (boolean)true);
            }
            return false;
        }

        public boolean addToConfig(Origin origin) {
            JsonObject originObj;
            boolean changed = false;
            String originIdString = origin.getId().toString();
            if (!this.origins.has(originIdString) || !(this.origins.get(originIdString) instanceof JsonObject)) {
                originObj = new JsonObject();
                this.origins.add(originIdString, (JsonElement)originObj);
                changed = true;
            } else {
                originObj = (JsonObject)this.origins.get(originIdString);
            }
            if (!originObj.has("enabled") || !(originObj.get("enabled") instanceof JsonPrimitive)) {
                originObj.addProperty("enabled", Boolean.TRUE);
                changed = true;
            }
            for (Power power : origin.getPowers()) {
                String powerIdString = power.getId().toString();
                if (originObj.has(powerIdString) && originObj.get(powerIdString) instanceof JsonPrimitive) continue;
                originObj.addProperty(powerIdString, Boolean.TRUE);
                changed = true;
            }
            return changed;
        }
    }
}

