/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.command.argument.OriginArgumentType;
import io.github.apace100.origins.command.argument.OriginLayerArgumentType;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.packet.s2c.OpenChooseOriginScreenS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.registry.ModComponents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_8710;

public class OriginCommand {
    public static void register(CommandNode<class_2168> baseNode) {
        LiteralCommandNode originNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"origin").requires(source -> source.method_9259(2))).build();
        originNode.addChild(SetNode.get());
        originNode.addChild(HasNode.get());
        originNode.addChild(GetNode.get());
        originNode.addChild(GuiNode.get());
        originNode.addChild(RandomNode.get());
        baseNode.addChild((CommandNode)originNode);
    }

    private static Origin setAndGetRandomOrigin(class_3222 target, OriginLayer layer) {
        List<Origin> origins = layer.getRandomOrigins((class_1657)target).stream().filter(OriginManager::contains).map(OriginManager::get).toList();
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        Origin origin = origins.get(class_5819.method_43047().method_43048(origins.size()));
        boolean hadOriginBefore = originComponent.hadOriginBefore();
        boolean hadAllOrigins = originComponent.hasAllOrigins();
        originComponent.setOrigin(layer, origin);
        originComponent.checkAutoChoosingLayers((class_1657)target, false);
        originComponent.sync();
        if (originComponent.hasAllOrigins() && !hadAllOrigins) {
            OriginComponent.onChosen((class_1657)target, hadOriginBefore);
        }
        Origins.LOGGER.info("Player {} was randomly assigned the origin {} for layer {}", (Object)target.method_5477().getString(), (Object)origin.getId(), (Object)layer.getId());
        return origin;
    }

    private static void openLayer(class_3222 target, Optional<OriginLayer> targetLayer) {
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
        ObjectArrayList layers = new ObjectArrayList();
        targetLayer.ifPresentOrElse(((List)layers)::add, () -> OriginCommand.lambda$openLayer$1((List)layers));
        layers.stream().filter(OriginLayer::isEnabled).forEach(layer -> originComponent.setOrigin((OriginLayer)layer, Origin.EMPTY));
        boolean automaticallyAssigned = originComponent.checkAutoChoosingLayers((class_1657)target, false);
        int options = targetLayer.map(layer -> layer.getOriginOptionCount((class_1657)target)).orElseGet(() -> OriginLayerManager.getOriginOptionCount((class_1657)target));
        originComponent.selectingOrigin(!automaticallyAssigned || options > 0);
        originComponent.sync();
        if (originComponent.isSelectingOrigin()) {
            ServerPlayNetworking.send((class_3222)target, (class_8710)new OpenChooseOriginScreenS2CPacket(false));
        }
    }

    private static /* synthetic */ void lambda$openLayer$1(List layers) {
        layers.addAll(OriginLayerManager.values());
    }

    public static final class SetNode {
        public static CommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)OriginLayerArgumentType.layer()).then(class_2170.method_9244((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(SetNode::execute))))).build();
        }

        public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
            ObjectArrayList targets = new ObjectArrayList(class_2186.method_9312(context, (String)"targets"));
            OriginLayer layer = OriginLayerArgumentType.getLayer(context, "layer");
            Origin origin = OriginArgumentType.getOrigin(context, "origin");
            class_2168 source = (class_2168)context.getSource();
            int processedTargets = 0;
            if (origin.equals(Origin.EMPTY) || layer.getOrigins().contains(origin.getId())) {
                for (class_3222 target : targets) {
                    OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
                    boolean hadOriginBefore = originComponent.hadOriginBefore();
                    originComponent.setOrigin(layer, origin);
                    originComponent.sync();
                    OriginComponent.partialOnChosen((class_1657)target, hadOriginBefore, origin);
                    ++processedTargets;
                }
                if (processedTargets == 1) {
                    source.method_9226(() -> SetNode.lambda$execute$0((List)targets, layer, origin), true);
                } else {
                    int finalProcessedTargets = processedTargets;
                    source.method_9226(() -> class_2561.method_43469((String)"commands.origin.set.success.multiple", (Object[])new Object[]{finalProcessedTargets, layer.getName(), origin.getName()}), true);
                }
            } else {
                source.method_9213((class_2561)class_2561.method_54159((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.getId(), layer.getId()}));
            }
            return processedTargets;
        }

        private static /* synthetic */ class_2561 lambda$execute$0(List targets, OriginLayer layer, Origin origin) {
            return class_2561.method_43469((String)"commands.origin.set.success.single", (Object[])new Object[]{((class_3222)targets.getFirst()).method_5477(), layer.getName(), origin.getName()});
        }
    }

    public static final class HasNode {
        public static CommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)class_2170.method_9247((String)"has").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)OriginLayerArgumentType.layer()).then(class_2170.method_9244((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(HasNode::execute))))).build();
        }

        public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
            ObjectArrayList targets = new ObjectArrayList(class_2186.method_9312(context, (String)"targets"));
            OriginLayer layer = OriginLayerArgumentType.getLayer(context, "layer");
            Origin origin = OriginArgumentType.getOrigin(context, "origin");
            class_2168 source = (class_2168)context.getSource();
            int processedTargets = 0;
            if (origin.equals(Origin.EMPTY) || layer.getOrigins().contains(origin.getId())) {
                for (class_3222 target : targets) {
                    OriginComponent origincomponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
                    if (!origin.equals(Origin.EMPTY) && !origincomponent.hasOrigin(layer) || !origincomponent.getOrigin(layer).equals(origin)) continue;
                    ++processedTargets;
                }
                if (processedTargets == 0) {
                    source.method_9213((class_2561)class_2561.method_43471((String)"commands.execute.conditional.fail"));
                } else if (processedTargets == 1) {
                    source.method_9226(() -> class_2561.method_43471((String)"commands.execute.conditional.pass"), false);
                } else {
                    int finalProcessedTargets = processedTargets;
                    source.method_9226(() -> class_2561.method_43469((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{finalProcessedTargets}), false);
                }
            } else {
                source.method_9213((class_2561)class_2561.method_54159((String)"commands.origin.unregistered_in_layer", (Object[])new Object[]{origin.getId(), layer.getId()}));
            }
            return processedTargets;
        }
    }

    public static final class GetNode {
        public static CommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"layer", (ArgumentType)OriginLayerArgumentType.layer()).executes(GetNode::execute)))).build();
        }

        public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 target = class_2186.method_9315(context, (String)"target");
            OriginLayer layer = OriginLayerArgumentType.getLayer(context, "layer");
            class_2168 source = (class_2168)context.getSource();
            OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
            Origin origin = originComponent.getOrigin(layer);
            source.method_9226(() -> class_2561.method_43469((String)"commands.origin.get.result", (Object[])new Object[]{target.method_5477(), layer.getName(), origin.getName(), origin.getId().toString()}), false);
            return 1;
        }
    }

    public static final class GuiNode {
        public static CommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gui").executes(context -> GuiNode.openAll((CommandContext<class_2168>)context, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> GuiNode.openAll((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"layer", (ArgumentType)OriginLayerArgumentType.layer()).executes(GuiNode::openSpecific)))).build();
        }

        public static int openAll(CommandContext<class_2168> context, boolean self) throws CommandSyntaxException {
            class_2168 source = (class_2168)context.getSource();
            Collection<Object> targets = self ? List.of(source.method_9207()) : class_2186.method_9312(context, (String)"targets");
            for (class_3222 class_32222 : targets) {
                OriginCommand.openLayer(class_32222, Optional.empty());
            }
            source.method_9226(() -> class_2561.method_43469((String)"commands.origin.gui.all", (Object[])new Object[]{targets.size()}), true);
            return targets.size();
        }

        public static int openSpecific(CommandContext<class_2168> context) throws CommandSyntaxException {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            OriginLayer layer = OriginLayerArgumentType.getLayer(context, "layer");
            for (class_3222 target : targets) {
                OriginCommand.openLayer(target, Optional.of(layer));
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.origin.gui.layer", (Object[])new Object[]{targets.size(), layer.getName()}), true);
            return targets.size();
        }
    }

    public static final class RandomNode {
        public static CommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"random").executes(context -> RandomNode.randomizeAll((CommandContext<class_2168>)context, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> RandomNode.randomizeAll((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"layer", (ArgumentType)OriginLayerArgumentType.layer()).executes(RandomNode::randomizeSpecific)))).build();
        }

        public static int randomizeAll(CommandContext<class_2168> context, boolean self) throws CommandSyntaxException {
            class_2168 source = (class_2168)context.getSource();
            Collection<Object> targets = self ? List.of(source.method_9207()) : class_2186.method_9312(context, (String)"targets");
            List<OriginLayer> layers = OriginLayerManager.values().stream().filter(OriginLayer::isRandomAllowed).toList();
            for (class_3222 class_32222 : targets) {
                for (OriginLayer layer : layers) {
                    OriginCommand.setAndGetRandomOrigin(class_32222, layer);
                }
            }
            source.method_9226(() -> class_2561.method_43469((String)"commands.origin.random.all", (Object[])new Object[]{targets.size(), layers.size()}), true);
            return targets.size();
        }

        public static int randomizeSpecific(CommandContext<class_2168> context) throws CommandSyntaxException {
            ObjectArrayList targets = new ObjectArrayList(class_2186.method_9312(context, (String)"targets"));
            OriginLayer layer = OriginLayerArgumentType.getLayer(context, "layer");
            class_2168 source = (class_2168)context.getSource();
            AtomicReference<Origin> origin = new AtomicReference<Origin>();
            if (layer.isRandomAllowed()) {
                for (class_3222 target : targets) {
                    origin.set(OriginCommand.setAndGetRandomOrigin(target, layer));
                }
                if (targets.size() > 1) {
                    source.method_9226(() -> RandomNode.lambda$randomizeSpecific$3((List)targets, layer), true);
                } else {
                    source.method_9226(() -> RandomNode.lambda$randomizeSpecific$4((List)targets, origin, layer), true);
                }
            }
            return targets.size();
        }

        private static /* synthetic */ class_2561 lambda$randomizeSpecific$4(List targets, AtomicReference origin, OriginLayer layer) {
            return class_2561.method_43469((String)"commands.origin.random.success.single", (Object[])new Object[]{((class_3222)targets.getFirst()).method_5477(), ((Origin)origin.get()).getName(), layer.getName()});
        }

        private static /* synthetic */ class_2561 lambda$randomizeSpecific$3(List targets, OriginLayer layer) {
            return class_2561.method_43469((String)"commands.origin.random.success.multiple", (Object[])new Object[]{targets.size(), layer.getName()});
        }
    }
}

