/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.structure_pool.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.internal.StructurePoolExtension;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_3778;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8891;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_3778.class_4182.class})
public class StructurePoolBasedGenerator_StructurePoolGeneratorMixin {
    @Shadow
    @Final
    private class_2378<class_3785> field_25852;
    private HashMap<class_2960, HashMap<class_2960, Integer>> limitedSpawns = new HashMap();
    @Nullable
    private class_2960 currentPoolId;

    @WrapOperation(method={"generatePiece"}, at={@At(value="INVOKE", target="Lnet/minecraft/structure/pool/StructurePoolBasedGenerator$StructurePoolGenerator;lookupPool(Lnet/minecraft/structure/StructureTemplate$StructureBlockInfo;Lnet/minecraft/structure/pool/alias/StructurePoolAliasLookup;)Lnet/minecraft/registry/RegistryKey;")})
    private class_5321<class_3785> getPoolKey_Wrapped(class_3499.class_3501 structureBlockInfo, class_8891 aliasLookup, Operation<class_5321<class_3785>> original) {
        class_5321 key = (class_5321)original.call(new Object[]{structureBlockInfo, aliasLookup});
        class_2960 poolId = key.method_29177();
        if (!this.limitedSpawns.containsKey(poolId) && StructurePoolAPI.spawnLimitations.containsKey(poolId)) {
            HashMap<class_2960, Integer> freshLimitations = new HashMap<class_2960, Integer>();
            for (Map.Entry<class_2960, StructurePoolAPI.SpawnPerk> entry : StructurePoolAPI.spawnLimitations.get(poolId).entrySet()) {
                class_2960 structureId = entry.getKey();
                StructurePoolAPI.SpawnPerk spawnPerk = entry.getValue();
                int spawnLimit = spawnPerk.limit();
                freshLimitations.put(structureId, spawnLimit);
            }
            this.limitedSpawns.put(poolId, freshLimitations);
        }
        this.currentPoolId = key.method_29177();
        return key;
    }

    @WrapOperation(method={"generatePiece"}, at={@At(value="INVOKE", target="Lnet/minecraft/structure/pool/StructurePool;getElementIndicesInRandomOrder(Lnet/minecraft/util/math/random/Random;)Ljava/util/List;")})
    private List<class_3784> getElementIndicesInRandomOrder_Wrapped(class_3785 pool, class_5819 random, Operation<List<class_3784>> original) {
        List result = (List)original.call(new Object[]{pool, random});
        result.removeIf(element -> !this.limitAllowsSpawn((class_3784)element));
        return result;
    }

    @WrapOperation(method={"generatePiece"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private boolean children_Wrapped(List list, Object object, Operation<Boolean> original) {
        if (object instanceof class_3790) {
            class_3790 piece = (class_3790)object;
            this.consumeLimit(piece.method_16644());
        }
        return (Boolean)original.call(new Object[]{list, object});
    }

    @Unique
    @Nullable
    private class_2960 resolveStructureElementId(class_3784 element) {
        if (this.currentPoolId == null) {
            return null;
        }
        class_3785 pool = (class_3785)this.field_25852.method_10223(this.currentPoolId);
        if (pool == null) {
            return null;
        }
        return ((StructurePoolExtension)pool).identify(element);
    }

    private boolean limitAllowsSpawn(class_3784 element) {
        class_2960 structureId = this.resolveStructureElementId(element);
        if (structureId == null) {
            return true;
        }
        if (!this.limitedSpawns.containsKey(this.currentPoolId)) {
            return true;
        }
        if (!this.limitedSpawns.get(this.currentPoolId).containsKey(structureId)) {
            return true;
        }
        Integer limit = this.limitedSpawns.get(this.currentPoolId).get(structureId);
        return limit > 0;
    }

    private void consumeLimit(class_3784 element) {
        class_2960 structureId = this.resolveStructureElementId(element);
        if (structureId == null) {
            return;
        }
        HashMap<class_2960, Integer> poolSpecificLimits = this.limitedSpawns.get(this.currentPoolId);
        if (poolSpecificLimits == null) {
            return;
        }
        if (!poolSpecificLimits.containsKey(structureId)) {
            return;
        }
        Integer limit = poolSpecificLimits.get(structureId);
        if (limit > 0) {
            poolSpecificLimits.put(structureId, limit - 1);
        }
    }
}

