/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoubleBinaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2960;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleOperations;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.mixin.OperationArgumentTypeAccessor;
import virtuoel.pehkui.util.ReflectionUtils;

public class ScaleOperationArgumentType
implements ArgumentType<Operation> {
    private static final Collection<String> EXAMPLES = ScaleRegistries.SCALE_OPERATIONS.keySet().stream().map(class_2960::toString).collect(Collectors.toList());
    private static final SimpleCommandExceptionType INVALID_OPERATION = OperationArgumentTypeAccessor.getInvalidOperationException();
    private static final SimpleCommandExceptionType DIVISION_ZERO_EXCEPTION = OperationArgumentTypeAccessor.getDivisionZeroException();

    public static ScaleOperationArgumentType operation() {
        return new ScaleOperationArgumentType();
    }

    public static Operation getOperation(CommandContext<class_2168> commandContext, String string) throws CommandSyntaxException {
        return (Operation)commandContext.getArgument(string, Operation.class);
    }

    public Operation parse(StringReader stringReader) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw INVALID_OPERATION.create();
        }
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        return ScaleOperationArgumentType.getOperator(stringReader.getString().substring(i, stringReader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(ScaleRegistries.SCALE_OPERATIONS.keySet().stream().filter(id -> !id.equals((Object)ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_OPERATIONS))).map(id -> id.method_12836().equals("pehkui") ? id.method_12832() : id.toString()), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static Operation getOperator(String string) throws CommandSyntaxException {
        DoubleBinaryOperator entry = ScaleRegistries.getEntry(ScaleRegistries.SCALE_OPERATIONS, string.contains(":") ? ReflectionUtils.constructIdentifier(string) : Pehkui.id(string));
        if (entry == null || entry == ScaleOperations.NOOP) {
            throw INVALID_OPERATION.create();
        }
        if (entry == ScaleOperations.DIVIDE) {
            return (curr, arg) -> {
                if (arg == 0.0) {
                    throw DIVISION_ZERO_EXCEPTION.create();
                }
                return entry.applyAsDouble(curr, arg);
            };
        }
        return entry::applyAsDouble;
    }

    @FunctionalInterface
    public static interface Operation {
        public double apply(double var1, double var3) throws CommandSyntaxException;
    }
}

