/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client;

import java.util.LinkedHashMap;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.network.Packets;

public class ClientNetwork {
    public static void initializeHandlers() {
        ClientConfigurationNetworking.registerGlobalReceiver(Packets.ConfigSync.PACKET_ID, (packet, context) -> {
            SpellEngineMod.config = packet.config();
            context.responseSender().sendPacket((class_8710)new Packets.Ack("spell_engine:config"));
        });
        ClientConfigurationNetworking.registerGlobalReceiver(Packets.SpellRegistrySync.PACKET_ID, (packet, context) -> {
            SpellAssignments.decodeContent(packet.chunks());
            context.responseSender().sendPacket((class_8710)new Packets.Ack("spell_engine:spell_registry"));
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.ParticleBatches.PACKET_ID, (packet, context) -> {
            class_310 client = context.client();
            List<ParticleHelper.SpawnInstruction> instructions = ParticleHelper.convertToInstructions((class_1937)client.field_1687, packet);
            client.execute(() -> {
                for (ParticleHelper.SpawnInstruction instruction : instructions) {
                    instruction.perform((class_1937)client.field_1687);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellAnimation.PACKET_ID, (packet, context) -> {
            class_310 client = context.client();
            client.execute(() -> {
                class_1297 entity = client.field_1687.method_8469(packet.playerId());
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    ((AnimatablePlayer)player).playSpellAnimation(packet.type(), packet.name(), packet.speed());
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellCooldown.PACKET_ID, (packet, context) -> {
            class_310 client = context.client();
            client.execute(() -> ((SpellCasterEntity)client.field_1724).getCooldownManager().set(packet.spellId(), packet.duration()));
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellMessage.PACKET_ID, (packet, context) -> {
            class_310 client = context.client();
            client.execute(() -> {
                String translation = class_2477.method_10517().method_48307(packet.translationKey());
                HudMessages.INSTANCE.error(translation);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellCooldownSync.PACKET_ID, (packet, context) -> {
            class_310 client = context.client();
            client.execute(() -> {
                SpellCooldownManager cooldownManager = ((SpellCasterEntity)client.field_1724).getCooldownManager();
                List<class_2960> cooldownsBefore = cooldownManager.spellsOnCooldown();
                cooldownManager.acceptSync(packet.baseTick(), packet.cooldowns());
                List<class_2960> cooldownsAfter = cooldownManager.spellsOnCooldown();
                HudMessages.INSTANCE.onCooldownsChanged(cooldownsBefore, cooldownsAfter);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellContainerSync.PACKET_ID, (packet, context) -> {
            class_310 client = context.client();
            client.execute(() -> {
                class_746 player = client.field_1724;
                if (player != null) {
                    LinkedHashMap<String, SpellContainer> containers = ((SpellContainerSource.Owner)player).serverSideSpellContainers();
                    containers.clear();
                    containers.putAll(packet.containers());
                }
                SpellContainerSource.setDirty((class_1657)client.field_1724, SpellContainerSource.MAIN_HAND);
            });
        });
    }
}

